/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.part.PartBase;
import thaumicenergistics.part.PartSharedEssentiaBus;

public class PacketEssentiaFilterAction
implements IMessage {
    public ACTION action;
    public PartBase part;

    public PacketEssentiaFilterAction() {
    }

    public PacketEssentiaFilterAction(PartBase part, ACTION action) {
        this.part = part;
        this.action = action;
    }

    public void toBytes(ByteBuf buf) {
        TileEntity tile = this.part.getTile();
        BlockPos pos = tile.func_174877_v();
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
        buf.writeInt(tile.func_145831_w().field_73011_w.getDimension());
        buf.writeInt(this.part.side.ordinal());
        buf.writeInt(this.action.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        IPart part;
        BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        WorldServer world = DimensionManager.getWorld((int)buf.readInt());
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IPartHost && (part = ((IPartHost)tile).getPart(AEPartLocation.values()[buf.readInt()])) instanceof PartBase) {
            this.part = (PartBase)part;
        }
        this.action = ACTION.values()[buf.readInt()];
    }

    public static class Handler
    implements IMessageHandler<PacketEssentiaFilterAction, IMessage> {
        public IMessage onMessage(PacketEssentiaFilterAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                if (message.part instanceof PartSharedEssentiaBus) {
                    TileEntity connectedTE;
                    PartSharedEssentiaBus part = (PartSharedEssentiaBus)message.part;
                    if (message.action == ACTION.CLEAR) {
                        part.getConfig().clear();
                    } else if (message.action == ACTION.PARTITION && (connectedTE = part.getConnectedTE()) instanceof IAspectContainer) {
                        part.getConfig().partition((IAspectContainer)connectedTE);
                    }
                }
            });
            return null;
        }
    }

    public static enum ACTION {
        CLEAR,
        PARTITION;

    }
}

