/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.api.EssentiaStack;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.config.AESettings;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.AEEssentiaStack;
import thaumicenergistics.integration.appeng.ThEPartModel;
import thaumicenergistics.item.part.ItemEssentiaImportBus;
import thaumicenergistics.part.PartSharedEssentiaBus;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;

public class PartEssentiaImportBus
extends PartSharedEssentiaBus {
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("thaumicenergistics", "part/essentia_import_bus/base"), new ResourceLocation("thaumicenergistics", "part/essentia_import_bus/on"), new ResourceLocation("thaumicenergistics", "part/essentia_import_bus/off"), new ResourceLocation("thaumicenergistics", "part/essentia_import_bus/has_channel")};
    private static IPartModel MODEL_ON = new ThEPartModel(MODELS[0], MODELS[1]);
    private static IPartModel MODEL_OFF = new ThEPartModel(MODELS[0], MODELS[2]);
    private static IPartModel MODEL_HAS_CHANNEL = new ThEPartModel(MODELS[0], MODELS[3]);

    public PartEssentiaImportBus(ItemEssentiaImportBus item) {
        super(item);
    }

    @Override
    protected AESettings.SUBJECT getAESettingSubject() {
        return AESettings.SUBJECT.ESSENTIA_IMPORT_BUS;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(ThEApi.instance().config().tickTimeEssentiaImportBusMin(), ThEApi.instance().config().tickTimeEssentiaImportBusMax(), false, false);
    }

    @Override
    public boolean canWork() {
        return this.getConnectedTE() instanceof IAspectContainer;
    }

    @Override
    protected TickRateModulation doWork() {
        IAspectContainer container = (IAspectContainer)this.getConnectedTE();
        for (Aspect aspect : container.getAspects().getAspects()) {
            AEEssentiaStack toInsert;
            if (this.config.hasAspects() && !this.config.isInFilter(aspect)) continue;
            EssentiaStack inContainer = new EssentiaStack(aspect, Math.min(container.containerContains(aspect), this.calculateAmountToSend()));
            IStorageGrid storageGrid = (IStorageGrid)this.getGridNode().getGrid().getCache(IStorageGrid.class);
            IMEMonitor storage = storageGrid.getInventory((IStorageChannel)this.getChannel());
            if (!storage.canAccept((IAEStack)(toInsert = AEEssentiaStack.fromEssentiaStack(inContainer)))) continue;
            IAEEssentiaStack notInserted = (IAEEssentiaStack)storage.injectItems((IAEStack)toInsert, Actionable.SIMULATE, this.source);
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                toInsert.decStackSize(notInserted.getStackSize());
            }
            container.takeFromContainer(toInsert.getAspect(), (int)toInsert.getStackSize());
            storage.injectItems((IAEStack)toInsert, Actionable.MODULATE, this.source);
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return MODEL_HAS_CHANNEL;
            }
            return MODEL_ON;
        }
        return MODEL_OFF;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d vec3d) {
        if (player.func_70093_af() && AEUtil.isWrench(player.func_184586_b(hand), player, this.getTile().func_174877_v())) {
            return false;
        }
        if (ForgeUtil.isServer()) {
            GuiHandler.openGUI(ModGUIs.ESSENTIA_IMPORT_BUS, player, this.hostTile.func_174877_v(), this.side);
        }
        this.host.markForUpdate();
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper box) {
        box.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        box.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        box.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }
}

