/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.config;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import tyra314.toolprogression.ToolProgressionMod;
import tyra314.toolprogression.harvest.BlockHelper;
import tyra314.toolprogression.harvest.BlockOverwrite;

public class BlockOverwriteConfig {
    private final Map<String, BlockOverwrite> overwrites = new HashMap<String, BlockOverwrite>();
    private final Configuration cfg;

    BlockOverwriteConfig(Configuration file) {
        this.cfg = file;
    }

    private void handleBlockOverwrite(String block, String config, BlockOverwrite.OverwriteSource source, String sourceKey) {
        BlockOverwrite overwrite = BlockHelper.createFromConfigString(config, source, sourceKey);
        if (overwrite == null) {
            ToolProgressionMod.logger.log(Level.WARN, String.format("Invalid block overwrite config for block: %s (%s)", block, config));
        }
        if (this.overwrites.containsKey(block)) {
            if (this.overwrites.get((Object)block).source.hasLessPriority(source)) {
                this.overwrites.put(block, overwrite);
            }
        } else {
            this.overwrites.put(block, overwrite);
        }
    }

    public void load() {
        try {
            this.cfg.load();
            this.cfg.addCustomCategoryComment("block", "To add any overwrites, simply copy them over from the block.cfg");
            this.cfg.addCustomCategoryComment("oreDict", "Add overwrites to all blocks in the given OreDict entry");
            this.overwrites.clear();
            this.parseOreDictCategory(this.cfg.getCategory("oreDict"));
            this.parseBlockCategory(this.cfg.getCategory("block"));
        }
        catch (Exception e) {
            ToolProgressionMod.logger.log(Level.ERROR, "Problem loading block overwrites file!", (Throwable)e);
        }
        finally {
            if (this.cfg.hasChanged()) {
                this.cfg.save();
            }
        }
    }

    private void parseBlockCategory(ConfigCategory category) {
        String regex = "^(?<modid>[^:]+):(?<block>[^:]+):(?<meta>[\\d\\*]{1,2})$";
        Pattern pattern = Pattern.compile("^(?<modid>[^:]+):(?<block>[^:]+):(?<meta>[\\d\\*]{1,2})$");
        for (Map.Entry block_entry : category.entrySet()) {
            Matcher matcher = pattern.matcher((CharSequence)block_entry.getKey());
            if (matcher.find()) {
                if (matcher.group("meta").equals("*")) {
                    for (int i = 0; i < 16; ++i) {
                        String block = matcher.group("modid") + ":" + matcher.group("block") + ":" + i;
                        this.handleBlockOverwrite(block, ((Property)block_entry.getValue()).getString(), BlockOverwrite.OverwriteSource.Wildcard, (String)block_entry.getKey());
                    }
                    continue;
                }
                this.handleBlockOverwrite((String)block_entry.getKey(), ((Property)block_entry.getValue()).getString(), BlockOverwrite.OverwriteSource.Single, (String)block_entry.getKey());
                continue;
            }
            ToolProgressionMod.logger.log(Level.WARN, "Invalid block overwrite entry: ", block_entry.getKey());
        }
    }

    private void parseOreDictCategory(ConfigCategory category) {
        String regex = "^ore:(?<entry>.+)$";
        Pattern pattern = Pattern.compile("^ore:(?<entry>.+)$");
        for (Map.Entry ore_entry : category.entrySet()) {
            Matcher matcher = pattern.matcher((CharSequence)ore_entry.getKey());
            if (matcher.find()) {
                String entry = matcher.group("entry");
                if (!OreDictionary.doesOreNameExist((String)entry)) {
                    ToolProgressionMod.logger.log(Level.WARN, "Invalid oreDict overwrite entry: ", ore_entry.getKey());
                    continue;
                }
                NonNullList ores = OreDictionary.getOres((String)entry);
                for (ItemStack ore : ores) {
                    if (!(ore.func_77973_b() instanceof ItemBlock)) continue;
                    Block block = ((ItemBlock)ore.func_77973_b()).func_179223_d();
                    if (ore.func_77960_j() == Short.MAX_VALUE) {
                        for (IBlockState state : block.func_176194_O().func_177619_a()) {
                            String key = BlockHelper.getKeyString(state);
                            this.handleBlockOverwrite(key, ((Property)ore_entry.getValue()).getString(), BlockOverwrite.OverwriteSource.OreDict, (String)ore_entry.getKey());
                        }
                        continue;
                    }
                    String key = BlockHelper.getKeyFromItemStack(ore);
                    this.handleBlockOverwrite(key, ((Property)ore_entry.getValue()).getString(), BlockOverwrite.OverwriteSource.OreDict, (String)ore_entry.getKey());
                }
                continue;
            }
            ToolProgressionMod.logger.log(Level.WARN, "Invalid oreDict overwrite entry: ", ore_entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.cfg.addCustomCategoryComment("block", "To add any overwrites, simply copy them over from the block.cfg");
            ConfigCategory block = this.cfg.getCategory("block");
            block.clear();
            for (Map.Entry<String, BlockOverwrite> entry : this.overwrites.entrySet()) {
                BlockOverwrite overwrite = entry.getValue();
                if (overwrite.source == BlockOverwrite.OverwriteSource.OreDict) continue;
                if (overwrite.source == BlockOverwrite.OverwriteSource.Wildcard) {
                    block.put(overwrite.sourceKey, new Property(overwrite.sourceKey, overwrite.getConfig(), Property.Type.STRING));
                    continue;
                }
                if (overwrite.source != BlockOverwrite.OverwriteSource.Single) continue;
                block.put(entry.getKey(), new Property(entry.getKey(), overwrite.getConfig(), Property.Type.STRING));
            }
        }
        catch (Exception e) {
            ToolProgressionMod.logger.log(Level.ERROR, "Problem saving block overwrites file!", (Throwable)e);
        }
        finally {
            this.cfg.save();
        }
    }

    public BlockOverwrite get(String key) {
        if (this.overwrites.containsKey(key)) {
            return this.overwrites.get(key);
        }
        return null;
    }

    public BlockOverwrite get(IBlockState state) {
        return this.get(BlockHelper.getKeyString(state));
    }

    public void unset(String key) {
        this.overwrites.remove(key);
    }

    public void set(String key, BlockOverwrite overwrite) {
        this.overwrites.put(key, overwrite);
    }
}

