/*
 * Decompiled with CFR 0.152.
 */
package tyra314.toolprogression.harvest;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import tyra314.toolprogression.compat.exnihilo.ECEventHandler;
import tyra314.toolprogression.compat.exnihilo.ECHelper;
import tyra314.toolprogression.compat.gamestages.GSEventHandler;
import tyra314.toolprogression.compat.gamestages.GSHelper;
import tyra314.toolprogression.config.ConfigHandler;
import tyra314.toolprogression.harvest.BlockOverwrite;

public class HarvestHelper {
    public static Result canPlayerHarvestReason(EntityPlayer player, IBlockState state) {
        BlockOverwrite overwrite;
        if (GSHelper.isLoaded()) {
            state = GSEventHandler.getStagedBlockState(player, state);
        }
        if ((overwrite = ConfigHandler.blockOverwrites.get(state)) == null && state.func_185904_a().func_76229_l() || overwrite != null && !overwrite.toolRequired) {
            return Result.NONE;
        }
        String required_toolclass = state.func_177230_c().getHarvestTool(state);
        if (required_toolclass == null || required_toolclass.equals("null")) {
            return Result.NONE;
        }
        ItemStack tool = player.func_184614_ca();
        if (tool.func_190926_b()) {
            return Result.TOOL_CLASS;
        }
        if (ECHelper.isLoaded() && ECEventHandler.isHammerOrCrook(tool) && ECEventHandler.canHarvest(tool, state)) {
            return Result.NONE;
        }
        int tool_level = tool.func_77973_b().getHarvestLevel(tool, required_toolclass, player, state);
        if (tool_level < 0) {
            return Result.TOOL_CLASS;
        }
        int required_level = state.func_177230_c().getHarvestLevel(state);
        return tool_level >= required_level ? Result.NONE : Result.LEVEL;
    }

    public static boolean canPlayerHarvestBlock(EntityPlayer player, IBlockState state) {
        return HarvestHelper.canPlayerHarvestReason(player, state) == Result.NONE;
    }

    public static enum Result {
        TOOL_CLASS,
        LEVEL,
        NONE;

    }
}

