/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import com.teamacronymcoders.contenttweaker.api.ctobjects.resourcelocation.CTResourceLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import youyihj.zenutils.api.cotx.annotation.ExpandContentTweakerEntry;
import youyihj.zenutils.api.cotx.block.DirectionalBlockRepresentation;
import youyihj.zenutils.api.cotx.block.ExpandBlockContent;

@ExpandContentTweakerEntry
public abstract class DirectionalBlockContent
extends ExpandBlockContent {
    private final DirectionalBlockRepresentation representation;

    protected DirectionalBlockContent(DirectionalBlockRepresentation blockRepresentation) {
        super(blockRepresentation);
        this.representation = blockRepresentation;
    }

    public static DirectionalBlockContent create(final DirectionalBlockRepresentation blockRepresentation) {
        return new DirectionalBlockContent(blockRepresentation){

            @Override
            public DirectionalBlockRepresentation.Directions getDirections() {
                return blockRepresentation.getDirections();
            }
        };
    }

    public abstract DirectionalBlockRepresentation.Directions getDirections();

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getDirections().getBlockProperty()});
    }

    public int func_176201_c(IBlockState state) {
        return this.getDirections().toMeta(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.getDirections().toState(meta, this.func_176223_P());
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return this.getDirections().getValidFacings();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IProperty<EnumFacing> property = this.getDirections().getBlockProperty();
        switch (this.getDirections()) {
            case ALL: {
                Vec3d lookVec = placer.func_70040_Z();
                return this.func_176223_P().func_177226_a(property, (Comparable)EnumFacing.func_176737_a((float)((float)lookVec.field_72450_a), (float)((float)lookVec.field_72448_b), (float)((float)lookVec.field_72449_c)));
            }
            case HORIZONTAL: {
                return this.func_176223_P().func_177226_a(property, (Comparable)placer.func_174811_aO());
            }
            case VERTICAL: {
                Vec3d lookVec = placer.func_70040_Z();
                return this.func_176223_P().func_177226_a(property, (Comparable)(lookVec.field_72448_b > 0.0 ? EnumFacing.UP : EnumFacing.DOWN));
            }
        }
        return this.func_176223_P();
    }

    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        this.getResourceLocations(Lists.newArrayList()).forEach(resourceLocation -> {
            TemplateFile templateFile = TemplateManager.getTemplateFile((ResourceLocation)new ResourceLocation("zenutils", this.getDirections().name().toLowerCase(Locale.ENGLISH) + "_directional_block"));
            HashMap replacements = Maps.newHashMap();
            replacements.put("texture", Optional.ofNullable(this.representation.getTextureLocation()).map(CTResourceLocation::getInternal).map(ResourceLocation::toString).orElseGet(() -> new ResourceLocation(resourceLocation.func_110624_b(), "blocks/" + resourceLocation.func_110623_a()).toString()));
            templateFile.replaceContents((Map)replacements);
            models.add(new GeneratedModel(resourceLocation.func_110623_a(), ModelType.BLOCKSTATE, templateFile.getFileContents()));
        });
        return models;
    }

    @Override
    public DirectionalBlockRepresentation getExpandBlockRepresentation() {
        return this.representation;
    }
}

