/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.world.IWorld;
import java.util.Queue;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.util.catenation.CatenationContext;
import youyihj.zenutils.api.util.catenation.ICatenationTask;
import youyihj.zenutils.api.util.catenation.IWorldCondition;

@ZenRegister
@ZenClass(value="mods.zenutils.Catenation")
public class Catenation {
    private final Queue<ICatenationTask> tasks;
    private boolean stopped;
    @Nullable
    private final IWorldCondition stopWhen;
    private final CatenationContext context = new CatenationContext(this);

    public Catenation(Queue<ICatenationTask> tasks, @Nullable IWorldCondition stopWhen) {
        this.tasks = tasks;
        this.stopWhen = stopWhen;
    }

    @ZenMethod
    public boolean tick(IWorld world) {
        if (this.stopWhen != null) {
            try {
                if (this.stopWhen.apply(world, this.context)) {
                    this.stopped = true;
                }
            }
            catch (Exception exception) {
                CraftTweakerAPI.logError((String)"Exception occurred in stopWhen function, stopping the catenation...", (Throwable)exception);
                this.stopped = true;
            }
        }
        if (this.stopped) {
            return true;
        }
        ICatenationTask task = this.tasks.peek();
        if (task == null) {
            return true;
        }
        try {
            task.run(world, this.context);
        }
        catch (Exception exception) {
            CraftTweakerAPI.logError((String)"Exception occurred in a catenation task, stopping the catenation...", (Throwable)exception);
            return true;
        }
        if (task.isComplete()) {
            this.tasks.poll();
        }
        return false;
    }

    @ZenMethod
    public void stop() {
        this.stopped = true;
    }

    @ZenGetter(value="stopped")
    @ZenMethod
    public boolean isStopped() {
        return this.stopped;
    }

    @ZenGetter(value="context")
    @ZenMethod
    public CatenationContext getContext() {
        return this.context;
    }
}

