/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import stanhebben.zenscript.ZenModule;
import stanhebben.zenscript.value.IAny;
import youyihj.zenutils.ZenUtils;
import youyihj.zenutils.api.network.IByteBufWriter;
import youyihj.zenutils.api.network.IClientMessageHandler;
import youyihj.zenutils.api.network.IServerMessageHandler;
import youyihj.zenutils.impl.network.ValidateScriptMessage;
import youyihj.zenutils.impl.network.ZenUtilsMessage;
import youyihj.zenutils.impl.util.InternalUtils;

public enum ZenUtilsNetworkHandler {
    INSTANCE;

    private final SimpleNetworkWrapper channel = NetworkRegistry.INSTANCE.newSimpleChannel("zenutils");
    private final Int2ObjectArrayMap<IClientMessageHandler> clientHandlers = new Int2ObjectArrayMap();
    private final Int2ObjectArrayMap<IServerMessageHandler> serverHandlers = new Int2ObjectArrayMap();

    private ZenUtilsNetworkHandler() {
        this.channel.registerMessage(ZenUtilsMessage.Server2Client.class, ZenUtilsMessage.Server2Client.class, 0, Side.CLIENT);
        this.channel.registerMessage(ZenUtilsMessage.Client2Server.class, ZenUtilsMessage.Client2Server.class, 1, Side.SERVER);
        this.channel.registerMessage(ValidateScriptMessage.Handler.class, ValidateScriptMessage.class, 2, Side.SERVER);
    }

    public void registerServer2ClientMessage(String key, IClientMessageHandler clientMessageHandler) {
        this.clientHandlers.put(key.hashCode(), (Object)clientMessageHandler);
    }

    public void registerClient2ServerMessage(String key, IServerMessageHandler serverMessageHandler) {
        this.serverHandlers.put(key.hashCode(), (Object)serverMessageHandler);
    }

    public void sendToDimension(String key, IByteBufWriter byteBufWriter, int dimensionID) {
        this.channel.sendToDimension((IMessage)this.getServer2ClientMessage(key, byteBufWriter), dimensionID);
    }

    public void sendToAll(String key, IByteBufWriter byteBufWriter) {
        this.channel.sendToAll((IMessage)this.getServer2ClientMessage(key, byteBufWriter));
    }

    public void sendToAllAround(String key, IByteBufWriter byteBufWriter, double x, double y, double z, double range, int dimensionID) {
        this.channel.sendToAllAround((IMessage)this.getServer2ClientMessage(key, byteBufWriter), new NetworkRegistry.TargetPoint(dimensionID, x, y, z, range));
    }

    public void sendTo(String key, IByteBufWriter byteBufWriter, EntityPlayerMP player) {
        this.channel.sendTo((IMessage)this.getServer2ClientMessage(key, byteBufWriter), player);
    }

    public void sendToServer(String key, IByteBufWriter byteBufWriter) {
        this.channel.sendToServer((IMessage)this.getClient2ServerMessage(key, byteBufWriter));
    }

    IClientMessageHandler getClientMessageHandler(int key) {
        return (IClientMessageHandler)this.clientHandlers.getOrDefault((Object)key, (Object)IClientMessageHandler.NONE);
    }

    IServerMessageHandler getServerMessageHandler(int key) {
        return (IServerMessageHandler)this.serverHandlers.getOrDefault((Object)key, (Object)IServerMessageHandler.NONE);
    }

    private void sendValidateScriptMessage(byte[] scriptBytes, String scriptClassName) {
        this.channel.sendToServer((IMessage)new ValidateScriptMessage(scriptBytes, scriptClassName));
    }

    private ZenUtilsMessage.Server2Client getServer2ClientMessage(String key, IByteBufWriter byteBufWriter) {
        ZenUtilsMessage.Server2Client message = new ZenUtilsMessage.Server2Client();
        message.setKey(key);
        message.setByteBufWriter(Objects.requireNonNull(byteBufWriter));
        return message;
    }

    private ZenUtilsMessage.Client2Server getClient2ServerMessage(String key, IByteBufWriter byteBufWriter) {
        ZenUtilsMessage.Client2Server message = new ZenUtilsMessage.Client2Server();
        message.setKey(key);
        message.setByteBufWriter(Objects.requireNonNull(byteBufWriter));
        return message;
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static final class ClientEventHandler {
        @SubscribeEvent
        public static void onEntityJoin(EntityJoinWorldEvent event) {
            if (ZenUtils.crafttweakerLogger.hasError() || INSTANCE.serverHandlers.isEmpty()) {
                return;
            }
            if (event.getWorld().field_72995_K && event.getEntity().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ClientEventHandler.sendScriptsToServer();
            }
        }

        private static boolean isZenScriptAnonymousFunction(Class<?> scriptClass) {
            return scriptClass.getInterfaces().length == 1 && !InternalUtils.hasMethod(scriptClass, "__script__", new Class[0]) && !scriptClass.isSynthetic() && !IAny.class.isAssignableFrom(scriptClass) && !"__ZenMain__".equals(scriptClass.getCanonicalName());
        }

        private static void sendScriptsToServer() {
            for (Map.Entry entry : ZenModule.classes.entrySet()) {
                String name = (String)entry.getKey();
                byte[] bytecode = (byte[])entry.getValue();
                Class clazz = (Class)ZenModule.loadedClasses.get(name);
                if (bytecode.length == 0 || clazz == null || !ClientEventHandler.isZenScriptAnonymousFunction(clazz)) continue;
                INSTANCE.sendValidateScriptMessage(bytecode, name);
            }
        }
    }
}

