/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.gui;

import com.google.common.collect.Iterables;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiTextField;
import net.teamfruit.emojicord.EmojicordConfig;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.compat.CompatBaseVersion;
import net.teamfruit.emojicord.compat.CompatGui;
import net.teamfruit.emojicord.compat.CompatVersion;
import net.teamfruit.emojicord.emoji.DiscordEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.StandardEmojiIdDictionary;
import net.teamfruit.emojicord.gui.IChatOverlay;
import net.teamfruit.emojicord.gui.Rectangle2d;
import net.teamfruit.emojicord.util.MathHelper;
import net.teamfruit.lib.com.mojang.brigadier.Message;
import net.teamfruit.lib.com.mojang.brigadier.StringReader;
import net.teamfruit.lib.com.mojang.brigadier.suggestion.Suggestion;
import net.teamfruit.lib.com.mojang.brigadier.suggestion.Suggestions;
import net.teamfruit.lib.com.mojang.brigadier.suggestion.SuggestionsBuilder;
import org.apache.commons.lang3.StringUtils;

public class SuggestionChat
implements IChatOverlay {
    public final GuiChat chatScreen;
    public final GuiTextField inputField;
    public final FontRenderer font;
    public int mouseX;
    public int mouseY;
    private SuggestionsList suggestions;
    private CompletableFuture<Suggestions> pendingSuggestions;
    private boolean applyingSuggestion;
    private String inputFieldTextLast;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");

    public SuggestionChat(GuiChat chatScreen) {
        this.chatScreen = chatScreen;
        this.font = Compat.getMinecraft().field_71466_p;
        this.inputField = chatScreen.field_146415_a;
    }

    @Override
    public boolean onDraw() {
        if (this.suggestions != null) {
            this.suggestions.render();
        }
        this.checkTextUpdate();
        return false;
    }

    @Override
    public boolean onMouseClicked(int button) {
        return this.suggestions != null && this.suggestions.mouseClicked(button);
    }

    @Override
    public boolean onMouseScroll(double scrollDelta) {
        return this.suggestions != null && this.suggestions.mouseScrolled(scrollDelta);
    }

    @Override
    public boolean onMouseInput(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        return false;
    }

    @Override
    public boolean onKeyPressed(int keycode) {
        if (this.suggestions != null && this.suggestions.keyPressed(keycode)) {
            return true;
        }
        if (keycode == 258) {
            this.updateSuggestion(true);
        }
        return false;
    }

    public void checkTextUpdate() {
        String inputFieldText = this.inputField.func_146179_b();
        if (!StringUtils.equals((CharSequence)this.inputFieldTextLast, (CharSequence)inputFieldText)) {
            this.inputFieldTextLast = inputFieldText;
            this.updateSuggestion(false);
        }
    }

    public void showSuggestions() {
        if (this.pendingSuggestions != null && this.pendingSuggestions.isDone()) {
            int i = 0;
            Suggestions suggestions = this.pendingSuggestions.join();
            if (!suggestions.getList().isEmpty()) {
                for (Suggestion suggestion : suggestions.getList()) {
                    i = Math.max(i, this.font.func_78256_a(suggestion.getText() + " " + StringUtils.substringBetween((String)suggestion.getText(), (String)":")));
                }
                int j = MathHelper.clamp(CompatGui.CompatTextFieldWidget.getInsertPos(this.inputField, this.font, suggestions.getRange().getStart()), 0, this.chatScreen.field_146294_l - i);
                this.suggestions = new SuggestionsList(j, this.chatScreen.field_146295_m - 12, i, suggestions);
            }
        }
    }

    private void updateSuggestion(boolean skipCount) {
        StringReader stringreader;
        String s = this.inputField.func_146179_b();
        if (!this.applyingSuggestion) {
            CompatGui.CompatTextFieldWidget.setSuggestion(this.inputField, null);
            this.suggestions = null;
        }
        if ((stringreader = new StringReader(s)).canRead()) {
            int cursorPosition = this.inputField.func_146198_h();
            int lastWordIndex = SuggestionChat.getLastWordIndex(s);
            if (!(!(lastWordIndex < s.length() ? s.charAt(lastWordIndex) == ':' : s.length() > 0 && s.charAt(0) == ':') || !skipCount && cursorPosition - lastWordIndex < 3 || this.suggestions != null && this.applyingSuggestion)) {
                CompletableFuture<Iterable> list = CompletableFuture.supplyAsync(() -> Iterables.concat((Iterable)StandardEmojiIdDictionary.instance.nameDictionary.keySet(), DiscordEmojiIdDictionary.instance.get().keySet()));
                this.pendingSuggestions = list.thenApplyAsync(e -> SuggestionChat.suggest(e, new SuggestionsBuilder(s, lastWordIndex)));
                this.pendingSuggestions.thenRun(() -> {
                    if (this.pendingSuggestions.isDone()) {
                        this.updateUsageInfo();
                    }
                });
            }
        }
    }

    private void updateUsageInfo() {
        this.suggestions = null;
        if (EmojicordConfig.SUGGEST.autoSuggest.get().booleanValue()) {
            this.showSuggestions();
        }
    }

    private static Suggestions suggest(Iterable<String> collection, SuggestionsBuilder suggestionBuilder) {
        String s = suggestionBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String s1 : collection) {
            if (!(":" + s1.toLowerCase(Locale.ROOT) + ":").startsWith(s)) continue;
            suggestionBuilder.suggest(":" + s1 + ":");
        }
        Suggestions result = suggestionBuilder.build();
        return result;
    }

    public static int getLastWordIndex(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    public static String calculateSuggestionSuffix(String text, String textwithsuffix) {
        return textwithsuffix.startsWith(text) ? textwithsuffix.substring(text.length()) : null;
    }

    public static String getEmojiDisplayText(String text) {
        return text + " " + StringUtils.substringBetween((String)text, (String)":");
    }

    private class SuggestionsList {
        private final Rectangle2d rectangle;
        private final Suggestions suggestions;
        private final String text;
        private int scrollY;
        private int selectedIndex;
        private int lastMouseX;
        private int lastMouseY;
        private boolean arrowKeyUsed;

        private SuggestionsList(int posX, int posY, int width, Suggestions suggestions) {
            this.rectangle = new Rectangle2d(posX - 1, posY - 3 - Math.min(suggestions.getList().size(), 10) * 12, width + 1, Math.min(suggestions.getList().size(), 10) * 12);
            this.suggestions = suggestions;
            this.text = SuggestionChat.this.inputField.func_146179_b();
            this.select(0);
        }

        public void render() {
            Message message;
            boolean isMouseMoved;
            int i = Math.min(this.suggestions.getList().size(), 10);
            boolean isScrollTop = this.scrollY > 0;
            boolean isScrollBottom = this.suggestions.getList().size() > this.scrollY + i;
            boolean isScroll = isScrollTop || isScrollBottom;
            boolean bl = isMouseMoved = this.lastMouseX != SuggestionChat.this.mouseX || this.lastMouseY != SuggestionChat.this.mouseY;
            if (isMouseMoved) {
                this.lastMouseX = SuggestionChat.this.mouseX;
                this.lastMouseY = SuggestionChat.this.mouseY;
            }
            if (isScroll) {
                IChatOverlay.fill(this.rectangle.getX(), this.rectangle.getY() - 1, this.rectangle.getX() + this.rectangle.getWidth(), this.rectangle.getY(), -805306368);
                IChatOverlay.fill(this.rectangle.getX(), this.rectangle.getY() + this.rectangle.getHeight(), this.rectangle.getX() + this.rectangle.getWidth(), this.rectangle.getY() + this.rectangle.getHeight() + 1, -805306368);
                if (isScrollTop) {
                    for (int k = 0; k < this.rectangle.getWidth(); ++k) {
                        if (k % 2 != 0) continue;
                        IChatOverlay.fill(this.rectangle.getX() + k, this.rectangle.getY() - 1, this.rectangle.getX() + k + 1, this.rectangle.getY(), -1);
                    }
                }
                if (isScrollBottom) {
                    for (int i1 = 0; i1 < this.rectangle.getWidth(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        IChatOverlay.fill(this.rectangle.getX() + i1, this.rectangle.getY() + this.rectangle.getHeight(), this.rectangle.getX() + i1 + 1, this.rectangle.getY() + this.rectangle.getHeight() + 1, -1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestions.getList().get(l + this.scrollY);
                IChatOverlay.fill(this.rectangle.getX(), this.rectangle.getY() + 12 * l, this.rectangle.getX() + this.rectangle.getWidth(), this.rectangle.getY() + 12 * l + 12, -805306368);
                if (SuggestionChat.this.mouseX > this.rectangle.getX() && SuggestionChat.this.mouseX < this.rectangle.getX() + this.rectangle.getWidth() && SuggestionChat.this.mouseY > this.rectangle.getY() + 12 * l && SuggestionChat.this.mouseY < this.rectangle.getY() + 12 * l + 12) {
                    if (isMouseMoved) {
                        this.select(l + this.scrollY);
                    }
                    flag4 = true;
                }
                SuggestionChat.this.font.func_175063_a(SuggestionChat.getEmojiDisplayText(suggestion.getText()), (float)(this.rectangle.getX() + 1), (float)(this.rectangle.getY() + 2 + 12 * l), l + this.scrollY == this.selectedIndex ? -256 : -5592406);
            }
            if (!flag4 || (message = this.suggestions.getList().get(this.selectedIndex).getTooltip()) != null) {
                // empty if block
            }
        }

        public boolean mouseClicked(int clickButton) {
            if (!this.rectangle.contains(SuggestionChat.this.mouseX, SuggestionChat.this.mouseY)) {
                return false;
            }
            int i = (SuggestionChat.this.mouseY - this.rectangle.getY()) / 12 + this.scrollY;
            if (i >= 0 && i < this.suggestions.getList().size()) {
                this.select(i);
                this.useSuggestion();
            }
            return true;
        }

        public boolean mouseScrolled(double wheelScroll) {
            if (this.rectangle.contains(SuggestionChat.this.mouseX, SuggestionChat.this.mouseY)) {
                this.scrollY = MathHelper.clamp((int)((double)this.scrollY - wheelScroll), 0, Math.max(this.suggestions.getList().size() - 10, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(int keyTyped) {
            if (keyTyped == 265) {
                this.cycle(-1);
                this.arrowKeyUsed = false;
                return true;
            }
            if (keyTyped == 264) {
                this.cycle(1);
                this.arrowKeyUsed = false;
                return true;
            }
            if (keyTyped == 258) {
                if (this.arrowKeyUsed) {
                    this.cycle(CompatGui.CompatScreen.hasShiftDown() ? -1 : 1);
                }
                this.useSuggestion();
                return true;
            }
            if ((keyTyped == 257 || keyTyped == 335) && EmojicordConfig.SUGGEST.enterSuggest.get().booleanValue()) {
                this.useSuggestion();
                return true;
            }
            if (keyTyped == 256) {
                this.hide();
                return true;
            }
            if (!(keyTyped != 262 && keyTyped != 263 || CompatVersion.version().newer(CompatBaseVersion.V13))) {
                CompatGui.CompatTextFieldWidget.setSuggestion(SuggestionChat.this.inputField, "");
                this.hide();
                return false;
            }
            return false;
        }

        public void cycle(int deltaIndex) {
            this.select(this.selectedIndex + deltaIndex);
            int i = this.scrollY;
            int j = this.scrollY + 10 - 1;
            if (this.selectedIndex < i) {
                this.scrollY = MathHelper.clamp(this.selectedIndex, 0, Math.max(this.suggestions.getList().size() - 10, 0));
            } else if (this.selectedIndex > j) {
                this.scrollY = MathHelper.clamp(this.selectedIndex + 1 - 10, 0, Math.max(this.suggestions.getList().size() - 10, 0));
            }
        }

        public void select(int index) {
            this.selectedIndex = index;
            if (this.selectedIndex < 0) {
                this.selectedIndex += this.suggestions.getList().size();
            }
            if (this.selectedIndex >= this.suggestions.getList().size()) {
                this.selectedIndex -= this.suggestions.getList().size();
            }
            Suggestion suggestion = this.suggestions.getList().get(this.selectedIndex);
            CompatGui.CompatTextFieldWidget.setSuggestion(SuggestionChat.this.inputField, SuggestionChat.calculateSuggestionSuffix(SuggestionChat.this.inputField.func_146179_b(), suggestion.apply(this.text)));
        }

        public void useSuggestion() {
            Suggestion suggestion = this.suggestions.getList().get(this.selectedIndex);
            SuggestionChat.this.applyingSuggestion = true;
            SuggestionChat.this.inputField.func_146180_a(suggestion.apply(this.text));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            SuggestionChat.this.inputField.func_146190_e(i);
            SuggestionChat.this.inputField.func_146199_i(i);
            this.select(this.selectedIndex);
            SuggestionChat.this.applyingSuggestion = false;
            this.arrowKeyUsed = true;
        }

        public void hide() {
            SuggestionChat.this.suggestions = null;
        }
    }
}

