/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util.text.adapter;

import io.github.lxgaming.sledgehammer.bridge.util.text.TextFormattingBridge;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import io.github.lxgaming.sledgehammer.util.text.EmptyTextComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class TextAdapter {
    public static final char CHARACTER = '&';
    private static final Pattern URL_PATTERN = Pattern.compile("(?:(https?)://)([-\\w_.]+\\.\\w+)(/\\S*)?");

    public static void sendErrorMessage(ICommandSender commandSender, ITextComponent component) {
        component.func_150256_b().func_150238_a(TextFormatting.RED);
        commandSender.func_145747_a(component);
    }

    public static void sendFeedback(ICommandSender commandSender, ITextComponent component) {
        commandSender.func_145747_a(component);
    }

    public static void sendMessage(EntityPlayer player, ITextComponent component) {
        player.func_145747_a(component);
    }

    public static void sendStatusMessage(EntityPlayer player, ITextComponent component) {
        player.func_146105_b(component, true);
    }

    public static void disconnect(EntityPlayerMP player, ITextComponent component) {
        player.field_71135_a.func_194028_b(component);
    }

    public static void sendMessage(EntityPlayerMP player, ChatType chatType, ITextComponent component) {
        player.field_71135_a.func_147359_a((Packet)new SPacketChat(component, chatType));
    }

    public static ITextComponent serializeLegacyWithLinks(String string) {
        return TextAdapter.serializeLegacyWithLinks(string, '&');
    }

    public static ITextComponent serializeLegacyWithLinks(String string, char character) {
        return TextAdapter.serializeLegacyWithLinks(string, character, TextFormatting.BLUE);
    }

    public static ITextComponent serializeLegacyWithLinks(String string, char character, TextFormatting ... textFormattings) {
        EmptyTextComponent rootTextComponent = new EmptyTextComponent();
        Matcher matcher = URL_PATTERN.matcher(string);
        int currentIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String url = matcher.group();
            String text = string.substring(currentIndex, startIndex);
            if (!text.isEmpty()) {
                rootTextComponent.func_150257_a(TextAdapter.serializeLegacy(text, character));
            }
            TextComponentString textComponent = new TextComponentString(url);
            textComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            for (TextFormatting textFormatting : textFormattings) {
                TextAdapter.applyStyle(textComponent.func_150256_b(), textFormatting);
            }
            rootTextComponent.func_150257_a((ITextComponent)textComponent);
            currentIndex = endIndex;
        }
        String text = string.substring(currentIndex);
        if (!text.isEmpty()) {
            rootTextComponent.func_150257_a(TextAdapter.serializeLegacy(text, character));
        }
        return rootTextComponent;
    }

    public static ITextComponent serializeLegacy(String string) {
        return TextAdapter.serializeLegacy(string, '&');
    }

    public static ITextComponent serializeLegacy(String string, char character) {
        String text;
        EmptyTextComponent rootTextComponent = new EmptyTextComponent();
        Style currentStyle = new Style();
        EmptyTextComponent parentTextComponent = rootTextComponent;
        int currentIndex = 0;
        int index = 0;
        while ((index = string.indexOf(character, index)) != -1) {
            int startIndex = index++;
            if (index == string.length()) break;
            TextFormatting textFormatting = TextAdapter.getTextFormatting(string.charAt(index));
            if (textFormatting == null) continue;
            String text2 = string.substring(currentIndex, startIndex);
            currentIndex = ++index;
            if (!text2.isEmpty()) {
                TextComponentString textComponent = new TextComponentString(text2);
                textComponent.func_150255_a(currentStyle.func_150232_l());
                TextAdapter.clearStyle(currentStyle);
                parentTextComponent.func_150257_a((ITextComponent)textComponent);
                parentTextComponent = textFormatting.func_96301_b() ? textComponent : rootTextComponent;
            } else if (!textFormatting.func_96301_b()) {
                parentTextComponent = rootTextComponent;
                TextAdapter.clearStyle(currentStyle);
            }
            TextAdapter.applyStyle(currentStyle, textFormatting);
        }
        if (!(text = string.substring(currentIndex)).isEmpty()) {
            TextComponentString textComponent = new TextComponentString(text);
            textComponent.func_150255_a(currentStyle);
            parentTextComponent.func_150257_a((ITextComponent)textComponent);
        }
        return rootTextComponent;
    }

    private static void clearStyle(Style style) {
        style.func_150227_a(null);
        style.func_150241_a(null);
        style.func_150238_a(null);
        style.func_150209_a(null);
        style.func_179989_a(null);
        style.func_150217_b(null);
        style.func_150237_e(null);
        style.func_150221_a(null);
        style.func_150225_c(null);
        style.func_150228_d(null);
    }

    private static void applyStyle(Style style, TextFormatting textFormatting) {
        if (textFormatting.func_96302_c()) {
            style.func_150238_a(textFormatting);
        } else if (textFormatting == TextFormatting.OBFUSCATED) {
            style.func_150237_e(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.BOLD) {
            style.func_150227_a(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.STRIKETHROUGH) {
            style.func_150225_c(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.UNDERLINE) {
            style.func_150228_d(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.ITALIC) {
            style.func_150217_b(Boolean.valueOf(true));
        } else if (textFormatting != TextFormatting.RESET) {
            throw new UnsupportedOperationException(String.format("Unsupported style: %s", textFormatting.name()));
        }
    }

    private static TextFormatting getTextFormatting(char character) {
        char formattingCode = Character.toLowerCase(character);
        for (TextFormatting textFormatting : TextFormatting.values()) {
            if (TextAdapter.getFormattingCode(textFormatting) != formattingCode) continue;
            return textFormatting;
        }
        return null;
    }

    private static char getFormattingCode(TextFormatting textFormatting) {
        if (TextFormattingBridge.class.isInstance(textFormatting)) {
            return Toolbox.cast(textFormatting, TextFormattingBridge.class).bridge$getFormattingCode();
        }
        return textFormatting.field_96329_z;
    }
}

