/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.aireducer.config;

import com.charles445.aireducer.AIReducer;
import com.charles445.aireducer.config.init.JsonConfigTaskDelay;
import com.charles445.aireducer.config.json.JsonFileName;
import com.charles445.aireducer.config.json.JsonTypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class JsonConfig {
    public static List<String> jsonErrors = new ArrayList<String>();
    public static Map<String, Integer> taskDelay = new HashMap<String, Integer>();

    public static void init() {
        taskDelay.putAll(JsonConfigTaskDelay.getDefaults());
        Map<String, Integer> taskDelayJson = JsonConfig.processJson(JsonFileName.taskDelay, taskDelay, true);
        if (taskDelayJson != null) {
            try {
                taskDelay.putAll(taskDelayJson);
                JsonConfig.manuallyWriteToJson(JsonFileName.taskDelay, taskDelay);
            }
            catch (Exception e) {
                AIReducer.logger.error("Failed to merge write taskDelay!");
            }
        }
        if (taskDelay == null) {
            taskDelay = new HashMap<String, Integer>();
        }
    }

    @Nullable
    public static <T> T processJson(JsonFileName jfn, T container, boolean forMerging) {
        try {
            return JsonConfig.processUncaughtJson(jfn, container, forMerging);
        }
        catch (Exception e) {
            AIReducer.logger.error("Error managing JSON File: " + jfn.get(), (Throwable)e);
            jsonErrors.add("config/aireducer/" + jfn.get() + " failed to load!");
            if (forMerging) {
                return null;
            }
            return container;
        }
    }

    @Nullable
    public static <T> T processUncaughtJson(JsonFileName jfn, T container, boolean forMerging) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        File jsonFile = new File(AIReducer.jsonDirectory, jsonFileName);
        if (jsonFile.exists()) {
            Gson gson = JsonConfig.buildNewGson();
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), type);
        }
        Gson gson = JsonConfig.buildNewGson();
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
        if (forMerging) {
            return null;
        }
        return container;
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Gson gson = JsonConfig.buildNewGson();
        File jsonFile = new File(AIReducer.jsonDirectory, jsonFileName);
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
    }

    private static Gson buildNewGson() {
        return new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2, 8}).create();
    }
}

