/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.aireducer.routine;

import com.charles445.aireducer.AIReducer;
import com.charles445.aireducer.ai.WrappedTask;
import com.charles445.aireducer.reflect.ReflectorMinecraft;
import com.charles445.aireducer.util.ErrorUtil;
import com.google.common.base.Function;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.pathfinding.PathNavigate;

public abstract class Routine {
    private Map<Class, Constructor> wrappedConstructorMap = new ConcurrentHashMap<Class, Constructor>();

    public abstract boolean canRun();

    public void runRoutine(EntityLiving entity, String domain, String path) {
        if (this.canRun()) {
            this.run(entity, domain, path);
        }
    }

    protected abstract void run(EntityLiving var1, String var2, String var3);

    protected void applyTickRate(EntityAITasks tasks, int tickRate) {
        if (ReflectorMinecraft.reflector == null) {
            return;
        }
        try {
            ReflectorMinecraft.reflector.f_EntityAITasks_tickRate.setInt(tasks, tickRate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setNavigator(EntityLiving entity, PathNavigate navigator) {
        if (ReflectorMinecraft.reflector == null) {
            return;
        }
        try {
            ReflectorMinecraft.reflector.f_EntityLiving_navigator.set(entity, navigator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean removeAllTasksOfClass(EntityLiving entity, Class classToRemove) {
        boolean found = false;
        Iterator iterator = entity.field_70714_bg.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (task.field_75733_a.getClass() != classToRemove) continue;
            ErrorUtil.debugDebug("Removing " + classToRemove.getName() + " from " + entity.getClass().getName());
            found = true;
            iterator.remove();
        }
        return found;
    }

    protected int tryAndReplaceAllTasks(EntityLiving entity, EntityAITasks tasks, @Nullable Class toMatch, Function<EntityAITasks.EntityAITaskEntry, EntityAIBase> action) {
        int count = 0;
        LinkedList<EntityAITasks.EntityAITaskEntry> entries = new LinkedList<EntityAITasks.EntityAITaskEntry>();
        for (EntityAITasks.EntityAITaskEntry entry : tasks.field_75782_a) {
            if (toMatch == null || toMatch == entry.field_75733_a.getClass()) {
                EntityAIBase newAI = (EntityAIBase)action.apply((Object)entry);
                if (newAI != null) {
                    EntityAITasks entityAITasks = tasks;
                    entityAITasks.getClass();
                    entries.add(new EntityAITasks.EntityAITaskEntry(entityAITasks, entry.field_75731_b, (EntityAIBase)action.apply((Object)entry)));
                    ++count;
                    continue;
                }
                ErrorUtil.debugError("tryAndReplaceAllTasks ERROR " + entity.getClass().getName() + " " + (toMatch == null ? "any" : toMatch.getClass().getName()));
                entries.add(entry);
                continue;
            }
            entries.add(entry);
        }
        if (count > 0) {
            ErrorUtil.debugDebug("Replacing " + count + " tasks of " + (toMatch == null ? "any" : toMatch.getName()));
            tasks.field_75782_a.clear();
            tasks.field_75782_a.addAll(entries);
        }
        return count;
    }

    protected void wrapTask(EntityLiving entity, EntityAITasks tasks, @Nullable Class clazz, Class<? extends WrappedTask> wrapperClazz) {
        this.tryAndReplaceAllTasks(entity, tasks, clazz, (Function<EntityAITasks.EntityAITaskEntry, EntityAIBase>)((Function)oldTaskEntry -> {
            try {
                Constructor construct = this.wrappedConstructorMap.get(wrapperClazz);
                if (construct == null) {
                    AIReducer.logger.info("Caching Wrapped Task Constructor: " + wrapperClazz.getName());
                    construct = wrapperClazz.getDeclaredConstructor(EntityLiving.class, EntityAIBase.class);
                    this.wrappedConstructorMap.put(wrapperClazz, construct);
                }
                WrappedTask wrapper = (WrappedTask)((Object)((Object)construct.newInstance(entity, oldTaskEntry.field_75733_a)));
                ErrorUtil.debugDebug("Wrapped task with priority " + oldTaskEntry.field_75731_b + ": " + oldTaskEntry.field_75733_a.getClass().getName() + " " + ((Object)((Object)wrapper)).getClass().getName());
                return wrapper;
            }
            catch (Exception e) {
                AIReducer.logger.error("Failed to reflect to requested WrappedTask constructor!", (Throwable)e);
                return oldTaskEntry.field_75733_a;
            }
        }));
    }

    protected void debugPrintTasks(EntityAITasks tasks) {
        for (EntityAITasks.EntityAITaskEntry entry : tasks.field_75782_a) {
            ErrorUtil.debugDebug("[" + entry.field_75731_b + ", " + entry.field_75733_a.getClass().getName() + "]");
        }
    }
}

