/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import java.io.IOException;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.gui.GuiBiblioTextField;
import jds.bibliocraft.items.ItemWaypointCompass;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.server.BiblioUpdateInv;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiWaypointCompass
extends GuiScreen {
    private int guiImageWidth = 256;
    private int guiImageHeight = 128;
    private GuiBiblioTextField textField;
    private GuiBiblioTextField textFieldX;
    private GuiBiblioTextField textFieldZ;
    private int xcoord;
    private int zcoord;
    private String wayPointName = " ";
    private GuiButton buttonAccept;
    private GuiButton buttonSetToCurrentLoc;
    private ItemStack compassStack;
    private ItemWaypointCompass compassItem;
    private int currxcoord;
    private int currzcoord;

    public GuiWaypointCompass(World world, EntityPlayer player, ItemStack compassstack) {
        this.compassStack = compassstack;
        this.compassItem = (ItemWaypointCompass)this.compassStack.func_77973_b();
        NBTTagCompound tags = this.compassStack.func_77978_p();
        if (tags == null) {
            this.compassItem.createNewNBT(compassstack);
        }
        if (tags != null) {
            this.xcoord = tags.func_74762_e("XCoord");
            this.zcoord = tags.func_74762_e("ZCoord");
            this.wayPointName = tags.func_74779_i("WaypointName");
        }
        this.currxcoord = (int)player.field_70165_t;
        this.currzcoord = (int)player.field_70161_v;
    }

    public void initNBTData() {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.buttonAccept = new GuiButton(0, widthRender + 145, heightRender + 68, 64, 20, I18n.func_74838_a((String)"gui.mapWaypoint.accept"));
        this.field_146292_n.add(this.buttonAccept);
        this.buttonSetToCurrentLoc = new GuiButton(1, widthRender + 47, heightRender + 68, 64, 20, I18n.func_74838_a((String)"gui.compass.currentlocation"));
        this.field_146292_n.add(this.buttonSetToCurrentLoc);
        this.textField = new GuiBiblioTextField(this.field_146289_q, widthRender + 17, heightRender + 28, 222, 12);
        this.textFieldX = new GuiBiblioTextField(this.field_146289_q, widthRender + 57, heightRender + 52, 70, 12);
        this.textFieldZ = new GuiBiblioTextField(this.field_146289_q, widthRender + 155, heightRender + 52, 70, 12);
        this.textField.setEnableBackgroundDrawing(false);
        this.textFieldX.setEnableBackgroundDrawing(false);
        this.textFieldZ.setEnableBackgroundDrawing(false);
        this.textField.setTextColor(0x404040);
        this.textFieldX.setTextColor(0x404040);
        this.textFieldZ.setTextColor(0x404040);
        this.textField.setMaxStringLength(42);
        this.textFieldX.setMaxStringLength(8);
        this.textFieldZ.setMaxStringLength(8);
        this.textField.setText(this.wayPointName);
        String xText = "" + this.xcoord;
        String zText = "" + this.zcoord;
        this.textFieldX.setText(xText);
        this.textFieldZ.setText(zText);
    }

    public void func_73863_a(int x, int y, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.COMPASSGUI);
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.func_73729_b(widthRender, heightRender, 0, 0, this.guiImageWidth, this.guiImageHeight);
        this.textField.drawTextBox();
        this.textFieldX.drawTextBox();
        this.textFieldZ.drawTextBox();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"gui.compass.x"), widthRender + 42, heightRender + 52, -1);
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"gui.compass.z"), widthRender + 140, heightRender + 52, -1);
        super.func_73863_a(x, y, f);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton click) {
        String ztest;
        String xtest;
        boolean packet;
        if (click.field_146127_k == 0 && (packet = this.sendPacket(xtest = this.textFieldX.getText(), ztest = this.textFieldZ.getText(), this.textField.getText()))) {
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_146297_k.func_147108_a((GuiScreen)null);
        }
        if (click.field_146127_k == 1) {
            this.textFieldX.setText("" + this.currxcoord);
            this.textFieldZ.setText("" + this.currzcoord);
        }
    }

    private boolean sendPacket(String xcoord, String zcoord, String name) {
        try {
            int newXcoord = Integer.parseInt(xcoord);
            int newZcoord = Integer.parseInt(zcoord);
            ItemStack updatedCompass = this.compassItem.writeNBT(this.compassStack, newXcoord, newZcoord, name);
            if (updatedCompass != ItemStack.field_190927_a) {
                try {
                    BiblioNetworking.INSTANCE.sendToServer((IMessage)new BiblioUpdateInv(updatedCompass, false));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("X or Z value must be an Integer. Positive of Negitave. No letters or decimals accepted.");
        }
        return false;
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        try {
            super.func_73864_a(par1, par2, par3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.textField.mouseClicked(par1, par2, par3);
        this.textFieldZ.mouseClicked(par1, par2, par3);
        this.textFieldX.mouseClicked(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) {
        if (!(this.textField.textboxKeyTyped(par1, par2) || this.textFieldZ.textboxKeyTyped(par1, par2) || this.textFieldX.textboxKeyTyped(par1, par2))) {
            try {
                super.func_73869_a(par1, par2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

