/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.biomestaff.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import p455w0rd.biomestaff.BiomeStaff;

public class PacketUpdateChunkRender
implements IMessage,
IMessageHandler<PacketUpdateChunkRender, IMessage> {
    BlockPos pos;
    int radius;
    byte biome;

    public PacketUpdateChunkRender() {
    }

    public PacketUpdateChunkRender(BlockPos pos, int radius, byte biome) {
        this.pos = pos;
        this.radius = radius;
        this.biome = biome;
    }

    public IMessage onMessage(PacketUpdateChunkRender message, MessageContext ctx) {
        int rad = message.radius;
        BlockPos pos = message.pos;
        World world = BiomeStaff.PROXY.getWorld();
        for (int x = pos.func_177958_n() - rad; x <= pos.func_177958_n() + rad; ++x) {
            for (int z = pos.func_177952_p() - rad; z <= pos.func_177952_p() + rad; ++z) {
                int relBlockX = x & 0xF;
                int relBlockZ = z & 0xF;
                Chunk chunk = world.func_175726_f(new BlockPos(x, pos.func_177956_o(), z));
                byte[] byteArray = chunk.func_76605_m();
                byte currentByte = byteArray[relBlockZ << 4 | relBlockX];
                if (currentByte == message.biome) continue;
                byteArray[relBlockZ << 4 | relBlockX] = message.biome;
                chunk.func_76616_a(byteArray);
                chunk.func_177427_f(true);
                BiomeStaff.PROXY.updateChunkRendering(x, z);
            }
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.radius = buf.readInt();
        this.biome = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.radius);
        buf.writeByte((int)this.biome);
    }
}

