/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.gen;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.command.delete.DeleteMassSubCommand;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.storage.MassCircleTask;
import pregenerator.impl.storage.PregenTask;

public class StartMassRadiusSubCommand
extends BasePregenCommand {
    public StartMassRadiusSubCommand() {
        super(7);
        this.addDescription(0, "Generation Type: Which shape the Generation should have");
        this.addDescription(1, "X Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "Z Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(3, "Radius: How big the Radius in Chunks should be. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(4, "(Optional) SplitRadius: In How much radius the Calculator should split the tasks. Default: 1000 Chunks, Max: 1000 Chunks, Min: 100 Chunks");
        this.addDescription(5, "(Optional) Dimension: The Dimension the Generation should be in (Auto Loads Dimensions)");
        this.addDescription(6, "(Optional) Processing Rule: Which type of Generation it should use.");
        this.addSuggestion("startmassradius square 0 0 10000", "Generates a 10000 Chunk Radius with multible tasks of 1000 Chunk Radius in the dimension the Sender is in");
        this.addSuggestion("startmassradius square 0 0 10000 100", "Generates a 10000 Chunk Radius with multible tasks of 100 Chunk Radius");
    }

    @Override
    public String getName() {
        return "startmassradius";
    }

    @Override
    public String getDescription() {
        return "Generates a Massive Amount of Area";
    }

    @Override
    public int getRequiredParameterCount() {
        return 4;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 4) {
            int type = StartMassRadiusSubCommand.getGenType(args[0]);
            FilePos center = StartMassRadiusSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int radius = StartMassRadiusSubCommand.getNumber(args[3], 0);
            int splitRadius = StartMassRadiusSubCommand.clamp(StartMassRadiusSubCommand.parseNumber(StartMassRadiusSubCommand.getArg(args, 4), 25000), 100, 25000);
            int dimension = StartMassRadiusSubCommand.getDimension(container, StartMassRadiusSubCommand.getArg(args, 5));
            int postRule = StartMassRadiusSubCommand.getProcessRule(StartMassRadiusSubCommand.getArg(args, 6));
            if (!StartMassRadiusSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            List<PregenTask> list = StartMassRadiusSubCommand.createTaskList(type, center = StartMassRadiusSubCommand.applySpawn(args[1], args[2], center, container.getWorldSpawn(dimension)), radius, dimension, postRule, splitRadius);
            if (list.isEmpty()) {
                container.sendChatMessage("No tasks could be created.");
                return;
            }
            container.sendChatMessage("Created " + list.size() + " Tasks");
            if (container.onProcessStarted(list.get(0))) {
                container.sendChatMessage("Pregenerator already running. Adding Task(s) to the TaskStorage");
            } else {
                container.getProcessor().startTask(list.get(0));
            }
            container.getStorage().savePregenTasks(list);
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return StartMassRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_TYPE);
        }
        if (commandIndex == 1 || commandIndex == 2) {
            return StartMassRadiusSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 3) {
            if (args[argLayer].startsWith("b")) {
                return StartMassRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_BLOCK);
            }
            return StartMassRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_CHUNK);
        }
        if (commandIndex == 4) {
            return StartMassRadiusSubCommand.getBestMatch(args, "100", "200", "300", "400", "500", "600", "700", "800", "900", "1000", "2000", "3000", "4000", "5000", "10000", "20000", "25000");
        }
        if (commandIndex == 5) {
            return StartMassRadiusSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 6) {
            return StartMassRadiusSubCommand.getBestMatch(args, CompleterHelper.GEN_PROCESS);
        }
        return new ArrayList<String>();
    }

    public static List<PregenTask> createTaskList(int type, FilePos center, int radius, int dimension, int postRule, int splitRadius) {
        if (radius <= splitRadius) {
            return Arrays.asList(new PregenTask(type, dimension, center.x, center.z, radius, 0, postRule));
        }
        int range = DoubleMath.roundToInt((double)((double)radius / (double)splitRadius), (RoundingMode)RoundingMode.UP);
        ArrayList<FilePos> workList = new ArrayList<FilePos>();
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                workList.add(new FilePos(x, z));
            }
        }
        workList.sort(new DeleteMassSubCommand.Sorter(center));
        ArrayList<PregenTask> task = new ArrayList<PregenTask>();
        for (FilePos pos : workList) {
            int xMin = StartMassRadiusSubCommand.clamp((pos.x - 1) * splitRadius - 1, -radius, radius);
            int zMin = StartMassRadiusSubCommand.clamp((pos.z - 1) * splitRadius - 1, -radius, radius);
            int xMax = StartMassRadiusSubCommand.clamp((pos.x + 1) * splitRadius, -radius, radius);
            int zMax = StartMassRadiusSubCommand.clamp((pos.z + 1) * splitRadius, -radius, radius);
            task.add(new MassCircleTask(type == 1, dimension, xMin, zMin, xMax, zMax, pos.x, pos.z, radius, postRule));
        }
        return task;
    }
}

