/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.vec;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.vec.IVecInt;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;

public class Ray2d {
    public double originOne;
    public double originTwo;
    public double directionOne;
    public double directionTwo;
    public EnumFacing.Axis one;
    public EnumFacing.Axis two;

    public Ray2d(EnumFacing.Axis one, EnumFacing.Axis two, Vector3d origin, double directionOne, double directionTwo) {
        this.one = one;
        this.two = two;
        this.originOne = RotationUtils.get((EnumFacing.Axis)one, (Tuple3d)origin);
        this.originTwo = RotationUtils.get((EnumFacing.Axis)two, (Tuple3d)origin);
        this.directionOne = directionOne;
        this.directionTwo = directionTwo;
    }

    public Ray2d(EnumFacing.Axis one, EnumFacing.Axis two, IVecInt origin, double directionOne, double directionTwo) {
        this.one = one;
        this.two = two;
        this.originOne = origin.get(one);
        this.originTwo = origin.get(two);
        this.directionOne = directionOne;
        this.directionTwo = directionTwo;
    }

    public double getOrigin(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.originOne;
        }
        return this.originTwo;
    }

    public double getDirection(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.directionOne;
        }
        return this.directionTwo;
    }

    public EnumFacing.Axis getOther(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.two;
        }
        return this.one;
    }

    public double get(EnumFacing.Axis axis, double value) {
        EnumFacing.Axis other = this.getOther(axis);
        return this.getOrigin(other) + this.getDirection(other) * (value - this.getOrigin(axis)) / this.getDirection(axis);
    }

    public Double getWithLimits(EnumFacing.Axis axis, double value) {
        return this.getWithLimits(axis, value, 0.0, 1.0);
    }

    public Double getWithLimits(EnumFacing.Axis axis, double value, double min, double max) {
        EnumFacing.Axis other = this.getOther(axis);
        double position = (value - this.getOrigin(axis)) / this.getDirection(axis);
        if (position < min || position > max) {
            return null;
        }
        return this.getOrigin(other) + this.getDirection(other) * position;
    }

    public boolean isCoordinateOnLine(int one, int two) {
        return this.get(this.one, one) == (double)two;
    }

    public boolean isCoordinateToTheRight(int one, int two) {
        double tempTwo = (double)two - this.originTwo;
        double tempOne = (double)one - this.originOne;
        return this.directionOne * tempTwo - this.directionTwo * tempOne < 0.0;
    }

    public Vector3d intersect(Ray2d line, int thirdValue) {
        if (this.directionOne * line.directionTwo - this.directionTwo * line.directionOne == 0.0) {
            return null;
        }
        Vector3d vec = new Vector3d((double)thirdValue, (double)thirdValue, (double)thirdValue);
        double t = ((line.originTwo - this.originTwo) * line.directionOne + this.originOne * line.directionTwo - line.originOne * line.directionTwo) / (line.directionOne * this.directionTwo - this.directionOne * line.directionTwo);
        RotationUtils.setValue((Tuple3d)vec, (double)(this.originOne + t * this.directionOne), (EnumFacing.Axis)this.one);
        RotationUtils.setValue((Tuple3d)vec, (double)(this.originTwo + t * this.directionTwo), (EnumFacing.Axis)this.two);
        return vec;
    }
}

