/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.world;

import com.creativemd.creativecore.common.world.CreativeWorld;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkProviderFake
implements IChunkProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Long> droppedChunksSet = Sets.newHashSet();
    public final IChunkGenerator chunkGenerator;
    public final IChunkLoader chunkLoader;
    public final Long2ObjectMap<Chunk> id2ChunkMap = new Long2ObjectOpenHashMap(4);
    public final CreativeWorld worldObj;
    private Set<Long> loadingChunks = Sets.newHashSet();
    private static Field loadedChunk = ReflectionHelper.findField(Chunk.class, (String[])new String[]{"loaded", "field_76636_d"});

    public ChunkProviderFake(CreativeWorld worldObjIn, IChunkLoader chunkLoaderIn, IChunkGenerator chunkGeneratorIn) {
        this.worldObj = worldObjIn;
        this.chunkLoader = chunkLoaderIn;
        this.chunkGenerator = chunkGeneratorIn;
    }

    public Collection<Chunk> getLoadedChunks() {
        return this.id2ChunkMap.values();
    }

    public void unload(Chunk chunkIn) {
        if (this.worldObj.field_73011_w.func_186056_c(chunkIn.field_76635_g, chunkIn.field_76647_h)) {
            this.droppedChunksSet.add(ChunkPos.func_77272_a((int)chunkIn.field_76635_g, (int)chunkIn.field_76647_h));
            if (this.markLoaded()) {
                chunkIn.func_177417_c(false);
            }
        }
    }

    public boolean markLoaded() {
        return true;
    }

    public void unloadAllChunks() {
        for (Chunk chunk : this.id2ChunkMap.values()) {
            this.unload(chunk);
        }
    }

    @Nullable
    public Chunk func_186026_b(int x, int z) {
        long i = ChunkPos.func_77272_a((int)x, (int)z);
        Chunk chunk = (Chunk)this.id2ChunkMap.get(i);
        if (!this.worldObj.field_72995_K || chunk == null || this.markLoaded()) {
            // empty if block
        }
        return chunk;
    }

    @Nullable
    public Chunk loadChunk(int x, int z) {
        return this.loadChunk(x, z, null);
    }

    @Nullable
    public Chunk loadChunk(int x, int z, Runnable runnable) {
        Chunk chunk = this.func_186026_b(x, z);
        if (chunk == null) {
            long pos = ChunkPos.func_77272_a((int)x, (int)z);
            chunk = this.loadChunkFromFile(x, z);
            this.id2ChunkMap.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
        }
        return chunk;
    }

    public Chunk func_186025_d(int x, int z) {
        Chunk chunk = this.loadChunk(x, z);
        if (chunk == null) {
            long i = ChunkPos.func_77272_a((int)x, (int)z);
            try {
                chunk = this.chunkGenerator.func_185932_a(x, z);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
                crashreportcategory.func_71507_a("Location", (Object)String.format("%d,%d", x, z));
                crashreportcategory.func_71507_a("Position hash", (Object)i);
                crashreportcategory.func_71507_a("Generator", (Object)this.chunkGenerator);
                throw new ReportedException(crashreport);
            }
            this.id2ChunkMap.put(i, (Object)chunk);
            chunk.func_76631_c();
            chunk.func_186030_a((IChunkProvider)this, this.chunkGenerator);
        }
        return chunk;
    }

    @Nullable
    private Chunk loadChunkFromFile(int x, int z) {
        try {
            Chunk chunk = this.chunkLoader.func_75815_a((World)this.worldObj, x, z);
            if (chunk != null) {
                chunk.func_177432_b(this.worldObj.func_82737_E());
            }
            loadedChunk.setBoolean(chunk, true);
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load chunk", (Throwable)exception);
            return null;
        }
    }

    private void saveChunkExtraData(Chunk chunkIn) {
        try {
            this.chunkLoader.func_75819_b((World)this.worldObj, chunkIn);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save entities", (Throwable)exception);
        }
    }

    private void saveChunkData(Chunk chunkIn) {
        try {
            chunkIn.func_177432_b(this.worldObj.func_82737_E());
            this.chunkLoader.func_75816_a((World)this.worldObj, chunkIn);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save chunk", (Throwable)ioexception);
        }
        catch (MinecraftException minecraftexception) {
            LOGGER.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)minecraftexception);
        }
    }

    public boolean saveChunks(boolean p_186027_1_) {
        int i = 0;
        ArrayList list = Lists.newArrayList((Iterable)this.id2ChunkMap.values());
        for (int j = 0; j < list.size(); ++j) {
            Chunk chunk = (Chunk)list.get(j);
            if (p_186027_1_) {
                this.saveChunkExtraData(chunk);
            }
            if (!chunk.func_76601_a(p_186027_1_)) continue;
            this.saveChunkData(chunk);
            chunk.func_177427_f(false);
            if (++i != 24 || p_186027_1_) continue;
            return false;
        }
        return true;
    }

    public boolean unloadQueuedChunks() {
        return false;
    }

    public boolean canSave() {
        return false;
    }

    public String func_73148_d() {
        return "ServerChunkCache: " + this.id2ChunkMap.size() + " Drop: " + this.droppedChunksSet.size();
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType creatureType, BlockPos pos) {
        return this.chunkGenerator.func_177458_a(creatureType, pos);
    }

    @Nullable
    public BlockPos getStrongholdGen(World worldIn, String structureName, BlockPos position, boolean p_180513_4_) {
        return this.chunkGenerator.func_180513_a(worldIn, structureName, position, p_180513_4_);
    }

    public int getLoadedChunkCount() {
        return this.id2ChunkMap.size();
    }

    public boolean chunkExists(int x, int z) {
        return this.id2ChunkMap.containsKey(ChunkPos.func_77272_a((int)x, (int)z));
    }

    public boolean func_191062_e(int p_191062_1_, int p_191062_2_) {
        return this.id2ChunkMap.containsKey(ChunkPos.func_77272_a((int)p_191062_1_, (int)p_191062_2_)) || this.chunkLoader.func_191063_a(p_191062_1_, p_191062_2_);
    }

    public boolean func_73156_b() {
        return false;
    }
}

