/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.google.common.collect.Maps;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionClient;
import org.cyclops.cyclopscore.inventory.container.button.IButtonClickAcceptorClient;
import org.cyclops.cyclopscore.network.packet.ButtonClickPacket;

public abstract class GuiContainerExtended
extends GuiContainer
implements IButtonClickAcceptorClient<GuiContainerExtended, ExtendedInventoryContainer>,
IValueNotifiable {
    private final Map<Integer, IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>> buttonActions = Maps.newHashMap();
    protected ExtendedInventoryContainer container;
    protected ResourceLocation texture;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public GuiContainerExtended(ExtendedInventoryContainer container) {
        super((Container)container);
        container.setGuiValueListener(this);
        this.container = container;
        this.texture = this.constructResourceLocation();
    }

    protected ExtendedInventoryContainer getContainer() {
        return this.container;
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation(this.container.getGuiProvider().getModGui().getModId(), this.getGuiTexture());
    }

    public abstract String getGuiTexture();

    public void func_73866_w_() {
        this.field_146999_f = this.getBaseXSize() + this.offsetX * 2;
        this.field_147000_g = this.getBaseYSize() + this.offsetY * 2;
        super.func_73866_w_();
    }

    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawCurrentScreen(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 166;
    }

    protected void func_146976_a(float f, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i + this.offsetX, this.field_147009_r + this.offsetY, 0, 0, this.field_146999_f - 2 * this.offsetX, this.field_147000_g - 2 * this.offsetY);
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        return this.func_146978_c(slotIn.field_75223_e - 1, slotIn.field_75221_f - 1, GuiHelpers.SLOT_SIZE, GuiHelpers.SLOT_SIZE, mouseX, mouseY);
    }

    public boolean func_146978_c(int left, int top, int right, int bottom, int pointX, int pointY) {
        return RenderHelpers.isPointInRegion(left, top, right, bottom, pointX - this.field_147003_i, pointY - this.field_147009_r);
    }

    public boolean isPointInRegion(Rectangle region, Point mouse) {
        return this.func_146978_c(region.x, region.y, region.width, region.height, mouse.x, mouse.y);
    }

    public void drawTooltip(List<String> lines, int x, int y) {
        GuiHelpers.drawTooltip(this, lines, x, y);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.requiresAction(button.field_146127_k)) {
            this.onButtonClick(button.field_146127_k);
        }
        if (this.getContainer().requiresAction(button.field_146127_k)) {
            this.getContainer().onButtonClick(button.field_146127_k);
            CyclopsCore._instance.getPacketHandler().sendToServer(new ButtonClickPacket(button.field_146127_k));
        }
    }

    @Override
    public void putButtonAction(int buttonId, IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean requiresAction(int buttonId) {
        return this.buttonActions.containsKey(buttonId);
    }

    @Override
    public void onButtonClick(int buttonId) {
        IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this, this.getContainer());
        }
    }

    @Override
    public void onUpdate(int valueId, NBTTagCompound value) {
    }

    protected void refreshValues() {
        for (int id : this.getContainer().getValueIds()) {
            this.onUpdate(id, this.getContainer().getValue(id));
        }
    }

    public int getGuiLeftTotal() {
        return this.field_147003_i + this.offsetX;
    }

    public int getGuiTopTotal() {
        return this.field_147009_r + this.offsetY;
    }

    @Override
    public String getGuiModId() {
        return this.getContainer().getGuiModId();
    }

    @Override
    public int getGuiId() {
        return this.getContainer().getGuiId();
    }
}

