/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.ddutils.math;

public final class GridUtils {
    public static GridPos numToPos(int num) {
        int layer = (int)Math.sqrt(num);
        int layerNumber = num - layer * layer;
        int x = layerNumber <= layer ? layer : layer - (layerNumber - layer);
        int z = layerNumber <= layer ? layerNumber : layer;
        return new GridPos(x, z);
    }

    public static int posToNum(GridPos pos) {
        int z;
        int x = pos.getX();
        if (x >= (z = pos.getZ())) {
            return x * x + z;
        }
        return (z + 1) * z + z - x;
    }

    public static final class GridPos {
        private final int x;
        private final int z;

        public GridPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GridPos)) {
                return false;
            }
            GridPos other = (GridPos)o;
            if (this.getX() != other.getX()) {
                return false;
            }
            return this.getZ() == other.getZ();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getX();
            result = result * 59 + this.getZ();
            return result;
        }

        public String toString() {
            return "GridUtils.GridPos(x=" + this.getX() + ", z=" + this.getZ() + ")";
        }
    }
}

