/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.client.DDGUIHandler;
import org.dimdev.dimdoors.proxy.IProxy;
import org.dimdev.dimdoors.shared.EventHandler;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.ModRecipes;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.commands.CommandDimTeleport;
import org.dimdev.dimdoors.shared.commands.CommandFabricConvert;
import org.dimdev.dimdoors.shared.commands.CommandPocket;
import org.dimdev.dimdoors.shared.commands.CommandSaveSchem;
import org.dimdev.dimdoors.shared.entities.EntityMonolith;
import org.dimdev.dimdoors.shared.items.ModItems;
import org.dimdev.dimdoors.shared.pockets.SchematicHandler;
import org.dimdev.dimdoors.shared.rifts.targets.EscapeTarget;
import org.dimdev.dimdoors.shared.rifts.targets.GlobalReference;
import org.dimdev.dimdoors.shared.rifts.targets.LimboTarget;
import org.dimdev.dimdoors.shared.rifts.targets.LocalReference;
import org.dimdev.dimdoors.shared.rifts.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.shared.rifts.targets.PocketExitMarker;
import org.dimdev.dimdoors.shared.rifts.targets.PrivatePocketExitTarget;
import org.dimdev.dimdoors.shared.rifts.targets.PrivatePocketTarget;
import org.dimdev.dimdoors.shared.rifts.targets.PublicPocketTarget;
import org.dimdev.dimdoors.shared.rifts.targets.RandomTarget;
import org.dimdev.dimdoors.shared.rifts.targets.RelativeReference;
import org.dimdev.dimdoors.shared.rifts.targets.Targets;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.dimdoors.shared.sound.ModSounds;
import org.dimdev.dimdoors.shared.tileentities.TileEntityEntranceRift;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;
import org.dimdev.dimdoors.shared.world.ModBiomes;
import org.dimdev.dimdoors.shared.world.ModDimensions;
import org.dimdev.dimdoors.shared.world.gateways.GatewayGenerator;

@Mod(modid="dimdoors", name="Dimensional Doors", version="3.0.10", acceptedMinecraftVersions="[1.12,1.13)", dependencies="required-after:forge@[14.23.5.2860,)")
public class DimDoors {
    public static final String MODID = "dimdoors";
    public static final String MODNAME = "Dimensional Doors";
    public static final String MCVERSIONS = "[1.12,1.13)";
    public static final String VERSION = "3.0.10";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.5.2860,)";
    @Mod.Instance(value="dimdoors")
    public static DimDoors instance;
    public static Logger log;
    @SidedProxy(clientSide="org.dimdev.dimdoors.proxy.ClientProxy", serverSide="org.dimdev.dimdoors.proxy.ServerProxy")
    public static IProxy proxy;
    public static File configurationFolder;

    @Mod.EventHandler
    public void onPreInitialization(FMLPreInitializationEvent event) {
        log = event.getModLog();
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        MinecraftForge.EVENT_BUS.register(ModBlocks.class);
        MinecraftForge.EVENT_BUS.register(ModItems.class);
        MinecraftForge.EVENT_BUS.register(ModRecipes.class);
        MinecraftForge.EVENT_BUS.register(ModSounds.class);
        MinecraftForge.EVENT_BUS.register(ModBiomes.class);
        MinecraftForge.EVENT_BUS.register(ModConfig.class);
        VirtualTarget.registry.put((Object)"available_link", RandomTarget.class);
        VirtualTarget.registry.put((Object)"escape", EscapeTarget.class);
        VirtualTarget.registry.put((Object)"global", GlobalReference.class);
        VirtualTarget.registry.put((Object)"limbo", LimboTarget.class);
        VirtualTarget.registry.put((Object)"local", LocalReference.class);
        VirtualTarget.registry.put((Object)"public_pocket", PublicPocketTarget.class);
        VirtualTarget.registry.put((Object)"pocket_entrance", PocketEntranceMarker.class);
        VirtualTarget.registry.put((Object)"pocket_exit", PocketExitMarker.class);
        VirtualTarget.registry.put((Object)"private", PrivatePocketTarget.class);
        VirtualTarget.registry.put((Object)"private_pocket_exit", PrivatePocketExitTarget.class);
        VirtualTarget.registry.put((Object)"relative", RelativeReference.class);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "mob_monolith"), EntityMonolith.class, (String)"monoliths", (int)0, (Object)instance, (int)70, (int)1, (boolean)true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation(MODID, "mob_monolith"), (int)0, (int)0xFFFFFF);
        GameRegistry.registerTileEntity(TileEntityEntranceRift.class, (String)"dimdoors:entrance_rift");
        GameRegistry.registerTileEntity(TileEntityFloatingRift.class, (String)"dimdoors:floating_rift");
        ModDimensions.registerDimensions();
        Targets.registerDefaultTargets();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new DDGUIHandler());
        configurationFolder = new File(event.getModConfigurationDirectory(), "/DimDoors");
        configurationFolder.mkdirs();
        proxy.onPreInitialization(event);
    }

    @Mod.EventHandler
    public void onInitialization(FMLInitializationEvent event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "dungeon_chest"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "dispenser_projectiles"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "dispenser_splash_potions"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "dispenser_potion_arrows"));
        SchematicHandler.INSTANCE.loadSchematics();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GatewayGenerator(), (int)0);
        proxy.onInitialization(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDimTeleport());
        event.registerServerCommand((ICommand)new CommandPocket());
        event.registerServerCommand((ICommand)new CommandSaveSchem());
        event.registerServerCommand((ICommand)new CommandFabricConvert());
    }

    public static void sendTranslatedMessage(Entity entity, String text, Object ... translationArgs) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_146105_b((ITextComponent)new TextComponentTranslation(text, translationArgs), ModConfig.general.useStatusBar);
        }
    }

    public static void chat(Entity entity, String text, Object ... translationArgs) {
        entity.func_145747_a((ITextComponent)new TextComponentTranslation(text, translationArgs));
    }

    public static File getConfigurationFolder() {
        return configurationFolder;
    }
}

