/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.blocks;

import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dimdev.ddutils.Location;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.IRiftProvider;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.tileentities.TileEntityEntranceRift;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;

public abstract class BlockDimensionalDoor
extends BlockDoor
implements IRiftProvider<TileEntityEntranceRift> {
    public BlockDimensionalDoor(Material material) {
        super(material);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState doorState = world.func_180495_p(state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? pos.func_177977_b() : pos);
        if (doorState.func_177230_c() != this) {
            return;
        }
        if (((Boolean)doorState.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() && entity.field_71088_bW == 0) {
            entity.field_71088_bW = 50;
            TileEntityEntranceRift rift = this.getRift(world, pos, state);
            boolean successful = rift.teleport(entity);
            if (successful) {
                entity.field_71088_bW = 0;
            }
            if (successful && entity instanceof EntityPlayer && !entity.func_70093_af() && ModConfig.general.closeDoorBehind && !((Boolean)doorState.func_177229_b((IProperty)field_176522_N)).booleanValue()) {
                this.func_176512_a(world, pos, false);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos blockpos = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : world.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        state = iblockstate.func_177231_a((IProperty)field_176519_b);
        world.func_180501_a(blockpos, state, 10);
        world.func_175704_b(blockpos, pos);
        world.func_180498_a(player, (Boolean)state.func_177229_b((IProperty)field_176519_b) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return true;
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (pos.func_177956_o() >= world.func_72800_K() - 1) {
            return false;
        }
        IBlockState stateUnder = world.func_180495_p(pos.func_177977_b());
        if (!stateUnder.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || stateUnder.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.SOLID) {
            return false;
        }
        IBlockState stateBottom = world.func_180495_p(pos);
        IBlockState stateTop = world.func_180495_p(pos.func_177984_a());
        return (stateBottom.func_177230_c().func_176200_f((IBlockAccess)world, pos) || stateBottom.func_177230_c() == ModBlocks.RIFT) && stateTop.func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.func_176509_j();
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_176509_j());
    }

    public TileEntityEntranceRift createNewTileEntity(World world, int meta) {
        TileEntityEntranceRift rift = new TileEntityEntranceRift();
        rift.orientation = ((EnumFacing)this.func_176203_a(meta).func_177229_b((IProperty)BlockDoor.field_176520_a)).func_176734_d();
        if (DimDoors.proxy.isClient()) {
            rift.extendUp += 1.0;
        }
        return rift;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!this.hasTileEntity(state)) {
            return;
        }
        TileEntityEntranceRift rift = this.getRift(world, pos, state);
        super.func_180663_b(world, pos, state);
        if (world.field_72995_K) {
            return;
        }
        if (rift.isLeaveRiftOnBreak() || rift.isRegistered() && RiftRegistry.instance().getSources(new Location(rift.func_145831_w(), rift.func_174877_v())).size() > 0 && !rift.isAlwaysDelete()) {
            world.func_175656_a(pos, ModBlocks.RIFT.func_176223_P());
            TileEntityFloatingRift newRift = (TileEntityFloatingRift)world.func_175625_s(pos);
            newRift.copyFrom(rift);
            newRift.updateType();
        } else {
            rift.unregister();
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Override
    public TileEntityEntranceRift getRift(World world, BlockPos pos, IBlockState state) {
        TileEntity topEntity;
        TileEntity bottomEntity;
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            bottomEntity = world.func_175625_s(pos);
            topEntity = world.func_175625_s(pos.func_177984_a());
        } else {
            bottomEntity = world.func_175625_s(pos.func_177977_b());
            topEntity = world.func_175625_s(pos);
        }
        if (bottomEntity instanceof TileEntityEntranceRift && topEntity instanceof TileEntityEntranceRift) {
            DimDoors.log.error("Dimensional door at " + pos + " in world " + world + " contained two rifts, please report this. Defaulting to bottom.");
            return (TileEntityEntranceRift)bottomEntity;
        }
        if (bottomEntity instanceof TileEntityEntranceRift) {
            return (TileEntityEntranceRift)bottomEntity;
        }
        if (topEntity instanceof TileEntityEntranceRift) {
            return (TileEntityEntranceRift)topEntity;
        }
        throw new RuntimeException("Dimensional door at " + pos + " in world " + world + " contained no rift.");
    }

    public abstract Item func_176509_j();
}

