/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.items;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RotatedLocation;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.items.ModCreativeTabs;
import org.dimdev.dimdoors.shared.rifts.targets.RiftReference;
import org.dimdev.dimdoors.shared.sound.ModSounds;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;

public class ItemStabilizedRiftSignature
extends Item {
    public static final String ID = "stabilized_rift_signature";

    public ItemStabilizedRiftSignature() {
        this.func_77625_d(1);
        this.func_77656_e(20);
        this.func_77637_a(ModCreativeTabs.DIMENSIONAL_DOORS_CREATIVE_TAB);
        this.func_77655_b(ID);
        this.setRegistryName(new ResourceLocation("dimdoors", ID));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("destination");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos blockPos = pos = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177972_a(side);
        if (!player.func_175151_a(pos, side.func_176734_d(), stack)) {
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        RotatedLocation target = ItemStabilizedRiftSignature.getTarget(stack);
        if (target == null) {
            ItemStabilizedRiftSignature.setSource(stack, new RotatedLocation(new Location(world, pos), player.field_70177_z, 0.0f));
            player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".stored", new Object[0]), true);
            world.func_184133_a(null, player.func_180425_c(), ModSounds.RIFT_START, SoundCategory.BLOCKS, 0.6f, 1.0f);
        } else {
            if (target.getLocation().getBlockState().func_177230_c() != ModBlocks.RIFT) {
                if (!target.getLocation().getBlockState().func_177230_c().func_176200_f((IBlockAccess)world, target.getLocation().getPos())) {
                    DimDoors.sendTranslatedMessage((Entity)player, "tools.target_became_block", new Object[0]);
                    return EnumActionResult.FAIL;
                }
                WorldServer targetWorld = target.getLocation().getWorld();
                targetWorld.func_175656_a(target.getLocation().getPos(), ModBlocks.RIFT.func_176223_P());
                TileEntityFloatingRift rift1 = (TileEntityFloatingRift)target.getLocation().getTileEntity();
                rift1.setTeleportTargetRotation(target.getYaw(), 0.0f);
                rift1.register();
            }
            world.func_175656_a(pos, ModBlocks.RIFT.func_176223_P());
            TileEntityFloatingRift rift2 = (TileEntityFloatingRift)world.func_175625_s(pos);
            rift2.setDestination(RiftReference.tryMakeRelative(new Location(world, pos), target.getLocation()));
            rift2.setTeleportTargetRotation(player.field_70177_z, 0.0f);
            rift2.register();
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".created", new Object[0]), true);
            world.func_184133_a(null, player.func_180425_c(), ModSounds.RIFT_END, SoundCategory.BLOCKS, 0.6f, 1.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    public static void setSource(ItemStack itemStack, RotatedLocation destination) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74782_a("destination", (NBTBase)destination.writeToNBT(new NBTTagCompound()));
    }

    public static void clearSource(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o("destination");
        }
    }

    public static RotatedLocation getTarget(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("destination")) {
            RotatedLocation transform = new RotatedLocation();
            transform.readFromNBT(itemStack.func_77978_p().func_74775_l("destination"));
            return transform;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        RotatedLocation transform = ItemStabilizedRiftSignature.getTarget(stack);
        if (transform != null) {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".bound.info"), (Object[])new Object[]{transform.getLocation().getX(), transform.getLocation().getY(), transform.getLocation().getZ(), transform.getLocation().dim}));
        } else {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".unbound.info"), (Object[])new Object[0]));
        }
    }
}

