/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.pockets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.ddutils.math.MathUtils;
import org.dimdev.ddutils.schem.Schematic;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.pockets.DefaultDungeonDestinations;
import org.dimdev.dimdoors.shared.pockets.SchematicHandler;
import org.dimdev.dimdoors.shared.rifts.registry.LinkProperties;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.shared.rifts.targets.PocketExitMarker;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.dimdoors.shared.tileentities.TileEntityEntranceRift;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.PocketRegistry;

public class PocketTemplate {
    private final String group;
    private final String id;
    private final String type;
    private final String name;
    private final String author;
    private Schematic schematic;
    private byte[] schematicBytecode;
    private final int size;
    private final int baseWeight;
    private static boolean isReplacingPlaceholders = false;

    public float getWeight(int depth) {
        if (depth == -1) {
            return this.baseWeight;
        }
        return this.baseWeight;
    }

    public static void replacePlaceholders(Schematic schematic) {
        isReplacingPlaceholders = true;
        ArrayList<NBTTagCompound> tileEntities = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound tileEntityNBT : schematic.tileEntities) {
            if (tileEntityNBT.func_74764_b("placeholder")) {
                NBTTagCompound newNBT;
                int x = tileEntityNBT.func_74762_e("x");
                int y = tileEntityNBT.func_74762_e("y");
                int z = tileEntityNBT.func_74762_e("z");
                IBlockState state = schematic.palette.get(schematic.blockData[x][y][z]);
                switch (tileEntityNBT.func_74779_i("placeholder")) {
                    case "deeper_depth_door": {
                        TileEntityEntranceRift rift = (TileEntityEntranceRift)state.func_177230_c().createTileEntity(null, state);
                        rift.func_174878_a(new BlockPos(x, y, z));
                        rift.setProperties(DefaultDungeonDestinations.pocketLinkProperties);
                        rift.setDestination(DefaultDungeonDestinations.deeperDungeonDestination);
                        rift.setLeaveRiftOnBreak(true);
                        newNBT = rift.serializeNBT();
                        break;
                    }
                    case "less_deep_depth_door": {
                        TileEntityEntranceRift rift = (TileEntityEntranceRift)state.func_177230_c().createTileEntity(null, state);
                        rift.func_174878_a(new BlockPos(x, y, z));
                        rift.setProperties(DefaultDungeonDestinations.pocketLinkProperties);
                        rift.setDestination(DefaultDungeonDestinations.shallowerDungeonDestination);
                        rift.setLeaveRiftOnBreak(true);
                        newNBT = rift.serializeNBT();
                        break;
                    }
                    case "overworld_door": {
                        TileEntityEntranceRift rift = (TileEntityEntranceRift)state.func_177230_c().createTileEntity(null, state);
                        rift.func_174878_a(new BlockPos(x, y, z));
                        rift.setProperties(DefaultDungeonDestinations.pocketLinkProperties);
                        rift.setDestination(DefaultDungeonDestinations.overworldDestination);
                        rift.setLeaveRiftOnBreak(true);
                        newNBT = rift.serializeNBT();
                        break;
                    }
                    case "entrance_door": {
                        TileEntityEntranceRift rift = (TileEntityEntranceRift)state.func_177230_c().createTileEntity(null, state);
                        rift.func_174878_a(new BlockPos(x, y, z));
                        rift.setProperties(DefaultDungeonDestinations.pocketLinkProperties);
                        rift.setDestination(DefaultDungeonDestinations.twoWayPocketEntrance);
                        rift.setLeaveRiftOnBreak(true);
                        newNBT = rift.serializeNBT();
                        break;
                    }
                    case "gateway_portal": {
                        TileEntityEntranceRift rift = (TileEntityEntranceRift)state.func_177230_c().createTileEntity(null, state);
                        rift.func_174878_a(new BlockPos(x, y, z));
                        rift.setProperties(DefaultDungeonDestinations.overworldLinkProperties);
                        rift.setDestination(DefaultDungeonDestinations.gatewayDestination);
                        rift.setCloseAfterPassThrough(true);
                        rift.setLeaveRiftOnBreak(true);
                        newNBT = rift.serializeNBT();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown tile entity placeholder: " + tileEntityNBT.func_74779_i("placeholder"));
                    }
                }
                tileEntities.add(newNBT);
                continue;
            }
            tileEntities.add(tileEntityNBT);
        }
        schematic.tileEntities = tileEntities;
        ArrayList<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound entitiesNBT : schematic.entities) {
            if (entitiesNBT.func_74764_b("placeholder")) {
                NBTTagCompound newNBT;
                double x = entitiesNBT.func_74769_h("x");
                double y = entitiesNBT.func_74769_h("y");
                double z = entitiesNBT.func_74769_h("z");
                float yaw = entitiesNBT.func_74760_g("yaw");
                float pitch = entitiesNBT.func_74760_g("pitch");
                switch (entitiesNBT.func_74779_i("placeholder")) {
                    case "monolith": {
                        newNBT = PocketTemplate.defaultMonolith(x, y, z, yaw, pitch);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown entity placeholder: " + entitiesNBT.func_74779_i("placeholder"));
                    }
                }
                entities.add(newNBT);
                continue;
            }
            entities.add(entitiesNBT);
        }
        schematic.entities = entities;
        isReplacingPlaceholders = false;
    }

    private static NBTTagCompound defaultMonolith(double x, double y, double z, float yaw, float pitch) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", "dimdoors:mob_monolith");
        compound.func_74782_a("Pos", (NBTBase)PocketTemplate.newDoubleNBTList(x, y, z));
        compound.func_74782_a("Motion", (NBTBase)PocketTemplate.newDoubleNBTList(0.0, 0.0, 0.0));
        compound.func_74782_a("Rotation", (NBTBase)PocketTemplate.newFloatNBTList(yaw, pitch));
        compound.func_74776_a("FallDistance", 0.0f);
        compound.func_74777_a("Fire", (short)0);
        compound.func_74777_a("Air", (short)300);
        compound.func_74757_a("OnGround", false);
        compound.func_74768_a("Dimension", 0);
        compound.func_74757_a("Invulnerable", false);
        compound.func_74768_a("PortalCooldown", 0);
        compound.func_186854_a("UUID", UUID.randomUUID());
        compound.func_74768_a("Aggro", 0);
        return compound;
    }

    private static NBTTagList newDoubleNBTList(double ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : numbers) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    private static NBTTagList newFloatNBTList(float ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        for (float d0 : numbers) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagFloat(d0));
        }
        return nbttaglist;
    }

    public void place(Pocket pocket, boolean setup) {
        pocket.setSize(this.size);
        int gridSize = PocketRegistry.instance(pocket.getDim()).getGridSize();
        int dim = pocket.getDim();
        WorldServer world = WorldUtils.getWorld(dim);
        int xBase = pocket.getX() * gridSize * 16;
        int yBase = 0;
        int zBase = pocket.getZ() * gridSize * 16;
        if (this.schematic == null) {
            DimDoors.log.debug("Schematic is null, trying to reload from byteArray.");
            this.schematic = SchematicHandler.INSTANCE.loadSchematicFromByteArray(this.schematicBytecode);
            PocketTemplate.replacePlaceholders(this.schematic);
        }
        DimDoors.log.info("Placing new pocket using schematic " + this.id + " at x = " + xBase + ", z = " + zBase);
        this.schematic.place((World)world, xBase, yBase, zBase);
        SchematicHandler.INSTANCE.incrementUsage(this);
        if (!setup && !SchematicHandler.INSTANCE.isUsedOftenEnough(this)) {
            this.schematic = null;
        }
    }

    public void setup(Pocket pocket, VirtualTarget linkTo, LinkProperties linkProperties) {
        VirtualTarget dest;
        int gridSize = PocketRegistry.instance(pocket.getDim()).getGridSize();
        int dim = pocket.getDim();
        WorldServer world = WorldUtils.getWorld(dim);
        int xBase = pocket.getX() * gridSize * 16;
        int yBase = 0;
        int zBase = pocket.getZ() * gridSize * 16;
        ArrayList<TileEntityRift> rifts = new ArrayList<TileEntityRift>();
        for (NBTTagCompound nBTTagCompound : this.schematic.tileEntities) {
            LootTable table;
            IInventory inventory;
            BlockPos pos = new BlockPos(xBase + nBTTagCompound.func_74762_e("x"), yBase + nBTTagCompound.func_74762_e("y"), zBase + nBTTagCompound.func_74762_e("z"));
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityRift) {
                DimDoors.log.debug("Rift found in schematic at " + pos);
                TileEntityRift rift = (TileEntityRift)tile;
                rift.getDestination().setLocation(new Location(rift.func_145831_w(), rift.func_174877_v()));
                rifts.add(rift);
                continue;
            }
            if (!(tile instanceof IInventory) || !(inventory = (IInventory)tile).func_191420_l() || !(tile instanceof TileEntityChest) && !(tile instanceof TileEntityDispenser)) continue;
            if (tile instanceof TileEntityChest) {
                DimDoors.log.debug("Now populating chest.");
                table = world.func_184146_ak().func_186521_a(new ResourceLocation("dimdoors:dungeon_chest"));
            } else {
                DimDoors.log.debug("Now populating dispenser.");
                table = world.func_184146_ak().func_186521_a(new ResourceLocation("dimdoors:dispenser_projectiles"));
            }
            LootContext ctx = new LootContext.Builder(world).func_186471_a();
            table.func_186460_a(inventory, world.field_73012_v, ctx);
            DimDoors.log.debug("Inventory should be populated now. Chest is: " + (inventory.func_191420_l() ? "emtpy." : "filled."));
            if (!inventory.func_191420_l()) continue;
            DimDoors.log.error(", however Inventory is: emtpy!");
        }
        HashMap<TileEntityRift, Float> entranceWeights = new HashMap<TileEntityRift, Float>();
        for (TileEntityRift rift : rifts) {
            if (!(rift.getDestination() instanceof PocketEntranceMarker)) continue;
            entranceWeights.put(rift, Float.valueOf(((PocketEntranceMarker)rift.getDestination()).getWeight()));
        }
        if (entranceWeights.size() == 0) {
            DimDoors.log.warn("Pocket had no possible entrance in schematic!");
            return;
        }
        TileEntityRift tileEntityRift = (TileEntityRift)MathUtils.weightedRandom(entranceWeights);
        for (TileEntityRift rift : rifts) {
            dest = rift.getDestination();
            if (!(dest instanceof PocketEntranceMarker)) continue;
            if (rift == tileEntityRift) {
                PocketRegistry.instance(dim).func_76185_a();
                rift.setDestination(((PocketEntranceMarker)dest).getIfDestination());
                rift.register();
                RiftRegistry.instance().addPocketEntrance(pocket, new Location(rift.func_145831_w(), rift.func_174877_v()));
                continue;
            }
            rift.setDestination(((PocketEntranceMarker)dest).getOtherwiseDestination());
        }
        for (TileEntityRift rift : rifts) {
            dest = rift.getDestination();
            if (!(dest instanceof PocketExitMarker)) continue;
            if (linkProperties != null) {
                rift.setProperties(linkProperties);
            }
            rift.setDestination(rift.getProperties() == null || !rift.getProperties().oneWay ? linkTo : null);
            if (!(rift instanceof TileEntityEntranceRift) || rift.isAlwaysDelete()) continue;
            ((TileEntityEntranceRift)rift).setLeaveRiftOnBreak(true);
        }
        for (TileEntityRift rift : rifts) {
            rift.register();
            rift.func_70296_d();
        }
        if (!SchematicHandler.INSTANCE.isUsedOftenEnough(this)) {
            this.schematic = null;
        }
    }

    public PocketTemplate(String group, String id, String type, String name, String author, Schematic schematic, byte[] schematicBytecode, int size, int baseWeight) {
        this.group = group;
        this.id = id;
        this.type = type;
        this.name = name;
        this.author = author;
        this.schematic = schematic;
        this.schematicBytecode = schematicBytecode;
        this.size = size;
        this.baseWeight = baseWeight;
    }

    public PocketTemplate(String group, String id, String type, String name, String author, int size, int baseWeight) {
        this.group = group;
        this.id = id;
        this.type = type;
        this.name = name;
        this.author = author;
        this.size = size;
        this.baseWeight = baseWeight;
    }

    public String getGroup() {
        return this.group;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    public void setSchematic(Schematic schematic) {
        this.schematic = schematic;
    }

    public void setSchematicBytecode(byte[] schematicBytecode) {
        this.schematicBytecode = schematicBytecode;
    }

    public int getSize() {
        return this.size;
    }

    public int getBaseWeight() {
        return this.baseWeight;
    }

    public static boolean isReplacingPlaceholders() {
        return isReplacingPlaceholders;
    }
}

