/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.registry;

import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.nbt.INBTStorable;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;

public abstract class RegistryVertex
implements INBTStorable {
    public int dim;
    public UUID id = UUID.randomUUID();

    public void sourceGone(RegistryVertex source) {
        DimDoors.log.debug("Notified vertex " + this + " that source " + source + " is gone");
        RiftRegistry.instance().markSubregistryDirty(this.dim);
    }

    public void targetGone(RegistryVertex target) {
        DimDoors.log.debug("Notified vertex " + this + " that target " + target + " is gone");
        RiftRegistry.instance().markSubregistryDirty(this.dim);
    }

    public void sourceAdded(RegistryVertex source) {
        DimDoors.log.debug("Notified vertex " + this + " that source " + source + " was added");
        RiftRegistry.instance().markSubregistryDirty(this.dim);
    }

    public void targetAdded(RegistryVertex target) {
        DimDoors.log.debug("Notified vertex " + this + " that target " + target + " was added");
        RiftRegistry.instance().markSubregistryDirty(this.dim);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return NBTUtils.writeToNBT(this, nbt);
    }

    public String toString() {
        return "RegistryVertex(dim=" + this.dim + ", id=" + this.id + ")";
    }
}

