/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.EntityUtils;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RGBA;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.IEntityTarget;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;
import org.dimdev.dimdoors.shared.world.limbo.WorldProviderLimbo;
import org.dimdev.dimdoors.shared.world.pocketdimension.WorldProviderPersonalPocket;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.PocketRegistry;
import org.dimdev.pocketlib.PrivatePocketData;

public class PrivatePocketExitTarget
extends VirtualTarget
implements IEntityTarget {
    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public boolean receiveEntity(Entity entity, float relativeYaw, float relativePitch) {
        UUID uuid = EntityUtils.getEntityOwnerUUID(entity);
        if (uuid != null) {
            Location destLoc = RiftRegistry.instance().getPrivatePocketExit(uuid);
            Pocket pocket = PrivatePocketData.instance().getPrivatePocket(uuid);
            if (this.location.getWorld().field_73011_w instanceof WorldProviderPersonalPocket && pocket != null && PocketRegistry.instance(pocket.getDim()).getPocketAt(this.location.pos).equals(pocket)) {
                RiftRegistry.instance().setLastPrivatePocketEntrance(uuid, this.location);
            }
            if (destLoc == null || !(destLoc.getTileEntity() instanceof TileEntityRift)) {
                if (destLoc == null) {
                    DimDoors.sendTranslatedMessage(entity, "rifts.destinations.private_pocket_exit.did_not_use_rift", new Object[0]);
                } else {
                    DimDoors.sendTranslatedMessage(entity, "rifts.destinations.private_pocket_exit.rift_has_closed", new Object[0]);
                }
                TeleportUtils.teleport(entity, WorldProviderLimbo.getLimboSkySpawn(entity));
                return false;
            }
            ((IEntityTarget)destLoc.getTileEntity()).receiveEntity(entity, relativeYaw, relativePitch);
            return true;
        }
        return false;
    }

    @Override
    public void register() {
        super.register();
        PocketRegistry privatePocketRegistry = PocketRegistry.instance(this.location.getDim());
        Pocket pocket = privatePocketRegistry.getPocketAt(this.location.getPos());
        RiftRegistry.instance().addPocketEntrance(pocket, this.location);
    }

    @Override
    public RGBA getColor() {
        return new RGBA(0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static PrivatePocketExitTargetBuilder builder() {
        return new PrivatePocketExitTargetBuilder();
    }

    public PrivatePocketExitTargetBuilder toBuilder() {
        return new PrivatePocketExitTargetBuilder();
    }

    @Override
    public String toString() {
        return "PrivatePocketExitTarget()";
    }

    public static class PrivatePocketExitTargetBuilder {
        PrivatePocketExitTargetBuilder() {
        }

        public PrivatePocketExitTarget build() {
            return new PrivatePocketExitTarget();
        }

        public String toString() {
            return "PrivatePocketExitTarget.PrivatePocketExitTargetBuilder()";
        }
    }
}

