/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.tools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.schem.Schematic;
import org.dimdev.dimdoors.shared.blocks.BlockDimensionalDoor;
import org.dimdev.dimdoors.shared.blocks.BlockFabric;
import org.dimdev.dimdoors.shared.blocks.BlockFabricAncient;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.rifts.registry.LinkProperties;
import org.dimdev.dimdoors.shared.rifts.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.shared.rifts.targets.PocketExitMarker;
import org.dimdev.dimdoors.shared.rifts.targets.PrivatePocketExitTarget;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.dimdoors.shared.tileentities.TileEntityEntranceRift;
import org.dimdev.dimdoors.shared.tools.Initializer;

public final class SchematicGenerator {
    public static void main(String ... args) throws IOException {
        File schematicDir;
        if (args.length > 1) {
            System.err.println("Too many arguments!");
            return;
        }
        if (args.length == 1) {
            schematicDir = new File(args[0]);
            if (!schematicDir.isDirectory()) {
                System.err.print("The directory " + args[0] + " couldn't be found!");
                return;
            }
        } else {
            schematicDir = new File("schematics/");
        }
        Initializer.initialize();
        List<Schematic> schematics = SchematicGenerator.generatePocketSchematics();
        String[] saveFolders = new String[]{"public/", "private/", "blank/", "blank/", "blank/"};
        int i = 0;
        for (Schematic schematic : schematics) {
            NBTTagCompound schematicNBT = schematic.saveToNBT();
            File saveFile = new File(schematicDir, saveFolders[i++ % saveFolders.length] + schematic.name + ".schem");
            saveFile.getParentFile().mkdirs();
            DataOutputStream schematicDataStream = new DataOutputStream(new FileOutputStream(saveFile));
            CompressedStreamTools.func_74799_a((NBTTagCompound)schematicNBT, (OutputStream)schematicDataStream);
            schematicDataStream.flush();
            schematicDataStream.close();
        }
    }

    public static List<Schematic> generatePocketSchematics() {
        ArrayList<Schematic> schematics = new ArrayList<Schematic>();
        for (int pocketSize = 0; pocketSize < 8; ++pocketSize) {
            schematics.add(SchematicGenerator.generateBlankWithDoor("public_pocket", pocketSize, ModBlocks.ANCIENT_FABRIC.func_176223_P(), ModBlocks.FABRIC.func_176223_P(), ModBlocks.IRON_DIMENSIONAL_DOOR, PocketExitMarker.builder().build(), LinkProperties.builder().groups(Collections.singleton(1)).linksRemaining(1).entranceWeight(1.0f).floatingWeight(1.0f).build()));
            schematics.add(SchematicGenerator.generateBlankWithDoor("private_pocket", pocketSize, ModBlocks.ANCIENT_FABRIC.func_176223_P().func_177226_a(BlockFabricAncient.COLOR, (Comparable)EnumDyeColor.WHITE), ModBlocks.FABRIC.func_176223_P().func_177226_a(BlockFabricAncient.COLOR, (Comparable)EnumDyeColor.WHITE), ModBlocks.PERSONAL_DIMENSIONAL_DOOR, PrivatePocketExitTarget.builder().build(), null));
            schematics.add(SchematicGenerator.generateBlank("blank_pocket", pocketSize, ModBlocks.ANCIENT_FABRIC.func_176223_P(), ModBlocks.FABRIC.func_176223_P()));
            schematics.add(SchematicGenerator.generateFrame("void_pocket", pocketSize, ModBlocks.FABRIC.func_176223_P().func_177226_a((IProperty)BlockFabric.field_176581_a, (Comparable)EnumDyeColor.LIGHT_BLUE)));
            schematics.add(SchematicGenerator.generateResizableFrame("resizable_pocket", pocketSize, ModBlocks.FABRIC.func_176223_P().func_177226_a((IProperty)BlockFabric.field_176581_a, (Comparable)EnumDyeColor.ORANGE)));
        }
        return schematics;
    }

    private static Schematic generateBlank(String baseName, int pocketSize, IBlockState outerWall, IBlockState innerWall) {
        int size = (pocketSize + 1) * 16 - 1;
        Schematic schematic = new Schematic(baseName + "_" + pocketSize, "DimDoors", (short)size, (short)size, (short)size);
        schematic.requiredMods = new String[]{"dimdoors"};
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    int layer = Collections.min(Arrays.asList(x, y, z, size - 1 - x, size - 1 - y, size - 1 - z));
                    if (layer == 0) {
                        schematic.setBlockState(x, y, z, outerWall);
                        continue;
                    }
                    if (layer >= 5) continue;
                    schematic.setBlockState(x, y, z, innerWall);
                }
            }
        }
        return schematic;
    }

    private static Schematic generateBlankWithDoor(String baseName, int pocketSize, IBlockState outerWall, IBlockState innerWall, BlockDimensionalDoor doorBlock, VirtualTarget exitDest, LinkProperties link) {
        short size = (short)((pocketSize + 1) * 16 - 1);
        Schematic schematic = SchematicGenerator.generateBlank(baseName, pocketSize, outerWall, innerWall);
        schematic.setBlockState((size - 1) / 2, 5, 4, doorBlock.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
        schematic.setBlockState((size - 1) / 2, 6, 4, doorBlock.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
        schematic.tileEntities = new ArrayList<NBTTagCompound>();
        TileEntityEntranceRift rift = (TileEntityEntranceRift)doorBlock.createTileEntity(null, doorBlock.func_176223_P());
        rift.setDestination(PocketEntranceMarker.builder().ifDestination(exitDest).build());
        rift.setProperties(link);
        rift.setLeaveRiftOnBreak(true);
        NBTTagCompound tileNBT = rift.serializeNBT();
        tileNBT.func_74768_a("x", (size - 1) / 2);
        tileNBT.func_74768_a("y", 5);
        tileNBT.func_74768_a("z", 4);
        schematic.tileEntities.add(tileNBT);
        return schematic;
    }

    private static Schematic generateFrame(String baseName, int chunkSize, IBlockState frame) {
        int size = (chunkSize + 1) * 16 - 1;
        Schematic schematic = new Schematic(baseName + "_" + chunkSize, "DimDoors", (short)size, (short)size, (short)size);
        schematic.requiredMods = new String[]{"dimdoors"};
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    int sides = 0;
                    if (x == 0 || x == size - 1) {
                        ++sides;
                    }
                    if (y == 0 || y == size - 1) {
                        ++sides;
                    }
                    if (z == 0 || z == size - 1) {
                        ++sides;
                    }
                    if (sides < 2) continue;
                    schematic.setBlockState(x, y, z, frame);
                }
            }
        }
        return schematic;
    }

    private static Schematic generateResizableFrame(String baseName, int chunkSize, IBlockState frame) {
        int size = (chunkSize + 1) * 16;
        Schematic schematic = new Schematic(baseName + "_" + chunkSize, "DimDoors", (short)size, (short)size, (short)size);
        schematic.requiredMods = new String[]{"dimdoors"};
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    int sides = 0;
                    if (x % 16 == 0) {
                        ++sides;
                    }
                    if (y % 16 == 0) {
                        ++sides;
                    }
                    if (z % 16 == 0) {
                        ++sides;
                    }
                    int cubeSides = 3;
                    int cubeSize = Math.max(x, Math.max(y, z));
                    if (cubeSize - x != 0) {
                        --cubeSides;
                    }
                    if (cubeSize - y != 0) {
                        --cubeSides;
                    }
                    if (cubeSize - z != 0) {
                        --cubeSides;
                    }
                    if (sides < 2 || cubeSides < 2) continue;
                    schematic.setBlockState(x, y, z, frame);
                }
            }
        }
        return schematic;
    }
}

