/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world.gateways;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.world.gateways.BaseGateway;
import org.dimdev.dimdoors.shared.world.gateways.GatewayLimbo;
import org.dimdev.dimdoors.shared.world.gateways.GatewaySandstonePillars;
import org.dimdev.dimdoors.shared.world.gateways.GatewayTwoPillars;
import org.dimdev.pocketlib.WorldProviderPocket;

public class GatewayGenerator
implements IWorldGenerator {
    private static final int CLUSTER_GROWTH_CHANCE = 80;
    private static final int MAX_CLUSTER_GROWTH_CHANCE = 100;
    private static final int MIN_RIFT_Y = 4;
    private static final int MAX_RIFT_Y = 240;
    private static final int CHUNK_LENGTH = 16;
    private static final int MAX_GATEWAY_GENERATION_ATTEMPTS = 10;
    private ArrayList<BaseGateway> gateways = new ArrayList();
    private BaseGateway defaultGateway = new GatewayTwoPillars();

    public GatewayGenerator() {
        this.gateways.add(new GatewaySandstonePillars());
        this.gateways.add(new GatewayLimbo());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int x;
        int y;
        if (world.field_72995_K || world.field_73011_w instanceof WorldProviderPocket || world.field_73011_w instanceof WorldProviderHell || world.field_73011_w instanceof WorldProviderEnd) {
            return;
        }
        boolean clusterGenerated = false;
        if (Arrays.binarySearch(ModConfig.world.clusterDimBlacklist, world.field_73011_w.func_186058_p().func_186068_a()) == -1) {
            for (double clusterGenChance = ModConfig.world.clusterGenChance; clusterGenChance > 0.0; clusterGenChance -= 1.0) {
                if (!(random.nextDouble() < clusterGenChance)) continue;
                do {
                    if ((y = world.func_189649_b(x = chunkX * 16 + random.nextInt(16), z = chunkZ * 16 + random.nextInt(16))) < 4 || y > 240 || !world.func_175623_d(new BlockPos(x, y + 1, z)) || world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_150357_h || world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() == Blocks.field_150357_h || world.func_180495_p(new BlockPos(x, y - 2, z)).func_177230_c() == Blocks.field_150357_h) continue;
                    world.func_175656_a(new BlockPos(x, y, z), ModBlocks.RIFT.func_176223_P());
                } while (random.nextInt(100) < 80);
                clusterGenerated = true;
            }
        }
        if (!clusterGenerated && Arrays.binarySearch(ModConfig.world.gatewayDimBlacklist, world.field_73011_w.func_186058_p().func_186068_a()) == -1) {
            for (double gatewayGenChance = ModConfig.world.gatewayGenChance; gatewayGenChance > 0.0; gatewayGenChance -= 1.0) {
                if (!(random.nextDouble() < gatewayGenChance)) continue;
                boolean valid = false;
                z = 0;
                y = 0;
                x = 0;
                for (int attempts = 0; attempts < 10 && !valid; ++attempts) {
                    x = chunkX * 16 + random.nextInt(16);
                    z = chunkZ * 16 + random.nextInt(16);
                    y = world.func_189649_b(x, z);
                    valid = GatewayGenerator.checkGatewayLocation(world, new BlockPos(x, y, z));
                }
                if (!valid) continue;
                ArrayList<BaseGateway> validGateways = new ArrayList<BaseGateway>();
                for (BaseGateway gateway : this.gateways) {
                    if (!gateway.isLocationValid(world, x, y, z)) continue;
                    validGateways.add(gateway);
                }
                if (validGateways.isEmpty()) {
                    validGateways.add(this.defaultGateway);
                }
                ((BaseGateway)validGateways.get(random.nextInt(validGateways.size()))).generate(world, x, y - 1, z);
            }
        }
    }

    private static boolean checkGatewayLocation(World world, BlockPos pos) {
        return pos.func_177956_o() >= 4 && pos.func_177956_o() <= 240 && world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && world.func_180495_p(pos.func_177977_b()) != Blocks.field_150357_h && GatewayGenerator.checkFoundationMaterial(world, pos.func_177977_b());
    }

    private static boolean checkFoundationMaterial(World world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        return material != Material.field_151584_j && material != Material.field_151575_d && material != Material.field_151572_C && world.func_175677_d(pos, false) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h;
    }
}

