/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world.limbo;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.world.ModDimensions;

public final class LimboDecay {
    private static final int MAX_DECAY_SPREAD_CHANCE = 100;
    private static final int DECAY_SPREAD_CHANCE = 50;
    private static final int CHUNK_SIZE = 16;
    private static final int SECTION_HEIGHT = 16;
    private static IBlockState[] decaySequence = null;
    private static final Random random = new Random();
    public static Block[] blocksImmuneToDecay = null;

    public static IBlockState[] getDecaySequence() {
        if (decaySequence == null) {
            decaySequence = new IBlockState[]{ModBlocks.UNRAVELLED_FABRIC.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150348_b.func_176223_P()};
        }
        return decaySequence;
    }

    public static Block[] getBlocksImmuneToDecay() {
        if (blocksImmuneToDecay == null) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add((Object)ModBlocks.UNRAVELLED_FABRIC);
            temp.add((Object)ModBlocks.ETERNAL_FABRIC);
            temp.add(ModBlocks.DIMENSIONAL_PORTAL);
            temp.add(ModBlocks.IRON_DIMENSIONAL_DOOR);
            temp.add(ModBlocks.WARP_DIMENSIONAL_DOOR);
            temp.add(ModBlocks.RIFT);
            temp.add((Object)ModBlocks.GOLD_DOOR);
            temp.add((Object)ModBlocks.QUARTZ_DOOR);
            temp.add(ModBlocks.GOLD_DIMENSIONAL_DOOR);
            for (String blocked : ModConfig.limbo.blockDecayLimboBlackList) {
                Block fromString = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blocked));
                if (fromString != null) {
                    temp.add(fromString);
                    continue;
                }
                DimDoors.log.error("Invalid block name for limbo decay blacklist! \"" + blocked + "\"");
            }
            blocksImmuneToDecay = temp.toArray(new Block[0]);
        }
        return blocksImmuneToDecay;
    }

    public static void applySpreadDecay(World world, BlockPos pos) {
        if (random.nextInt(100) < 50) {
            LimboDecay.decayBlock(world, pos.func_177984_a());
            LimboDecay.decayBlock(world, pos.func_177977_b());
            LimboDecay.decayBlock(world, pos.func_177978_c());
            LimboDecay.decayBlock(world, pos.func_177968_d());
            LimboDecay.decayBlock(world, pos.func_177976_e());
            LimboDecay.decayBlock(world, pos.func_177974_f());
        }
    }

    public static void applyRandomFastDecay() {
        int[] limbo;
        for (int i : limbo = DimensionManager.getDimensions((DimensionType)ModDimensions.LIMBO)) {
            WorldServer world = DimensionManager.getWorld((int)i);
            int limboHeight = world.func_72800_K();
            for (ChunkPos chunkPos : ForgeChunkManager.getPersistentChunksFor((World)world).keySet()) {
                for (int sectionY = 0; sectionY < limboHeight; sectionY += 16) {
                    BlockPos pos = new BlockPos(chunkPos.field_77276_a * 16 + random.nextInt(16), chunkPos.field_77275_b * 16 + random.nextInt(16), sectionY + random.nextInt(16));
                    LimboDecay.decayBlockFast((World)world, pos);
                }
            }
        }
    }

    private static boolean decayBlockFast(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        if (LimboDecay.canDecayBlock(block, world, pos)) {
            if (block.func_185915_l()) {
                world.func_175656_a(pos, ModBlocks.UNRAVELLED_FABRIC.func_176223_P());
            } else {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private static boolean decayBlock(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        if (LimboDecay.canDecayBlock(block, world, pos)) {
            if (block.func_185915_l()) {
                int index;
                for (index = 0; index < LimboDecay.getDecaySequence().length && !LimboDecay.getDecaySequence()[index].equals(block); ++index) {
                }
                world.func_175656_a(pos, LimboDecay.getDecaySequence()[index - 1]);
            } else {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private static boolean canDecayBlock(IBlockState state, World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        for (int k = 0; k < LimboDecay.getBlocksImmuneToDecay().length; ++k) {
            if (!state.func_177230_c().equals(LimboDecay.getBlocksImmuneToDecay()[k])) continue;
            return false;
        }
        return !(state instanceof BlockContainer);
    }
}

