/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.pocketlib;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.dimdev.ddutils.nbt.INBTStorable;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.pocketlib.PocketRegistry;
import org.dimdev.pocketlib.VirtualLocation;

public class Pocket
implements INBTStorable {
    protected int id;
    protected int x;
    protected int z;
    protected int size;
    protected VirtualLocation virtualLocation;
    int dim;

    public Pocket() {
    }

    public Pocket(int id, int dim, int x, int z) {
        this.id = id;
        this.dim = dim;
        this.x = x;
        this.z = z;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return NBTUtils.writeToNBT(this, nbt);
    }

    boolean isInBounds(BlockPos pos) {
        int gridSize = PocketRegistry.instance(this.dim).getGridSize();
        int minX = this.x * gridSize;
        int minZ = this.z * gridSize;
        int maxX = minX + (this.size + 1) * 16;
        int maxZ = minX + (this.size + 1) * 16;
        return minX <= pos.func_177958_n() && minZ <= pos.func_177952_p() && pos.func_177958_n() < maxX && pos.func_177952_p() < maxZ;
    }

    public BlockPos getOrigin() {
        int gridSize = PocketRegistry.instance(this.dim).getGridSize();
        return new BlockPos(this.x * gridSize * 16, 0, this.z * gridSize * 16);
    }

    public int getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public VirtualLocation getVirtualLocation() {
        return this.virtualLocation;
    }

    public void setVirtualLocation(VirtualLocation virtualLocation) {
        this.virtualLocation = virtualLocation;
    }

    public int getDim() {
        return this.dim;
    }
}

