/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.pocketlib;

import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.ddutils.nbt.INBTStorable;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.world.limbo.WorldProviderLimbo;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.PocketRegistry;
import org.dimdev.pocketlib.WorldProviderPocket;

public class VirtualLocation
implements INBTStorable {
    protected int dim;
    protected int x;
    protected int z;
    protected int depth;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return NBTUtils.writeToNBT(this, nbt);
    }

    public static VirtualLocation fromLocation(Location location) {
        VirtualLocation virtualLocation = null;
        if (location.getWorld().field_73011_w instanceof WorldProviderPocket) {
            Pocket pocket = PocketRegistry.instance(location.getDim()).getPocketAt(location.getPos());
            virtualLocation = pocket != null ? pocket.getVirtualLocation() : null;
        } else if (location.getWorld().field_73011_w instanceof WorldProviderLimbo) {
            virtualLocation = new VirtualLocation(location.getDim(), location.getX(), location.getZ(), ModConfig.dungeons.maxDungeonDepth);
        }
        if (virtualLocation == null) {
            virtualLocation = new VirtualLocation(0, location.getX(), location.getZ(), 5);
        }
        return virtualLocation;
    }

    public Location projectToWorld(boolean limboConsideredWorld) {
        WorldServer world = WorldUtils.getWorld(this.dim);
        if (!limboConsideredWorld && world.field_73011_w instanceof WorldProviderLimbo) {
            world = WorldUtils.getWorld(0);
        }
        float spread = ModConfig.general.depthSpreadFactor * this.depth;
        int newX = (int)((double)this.x + (double)(spread * 2.0f) * (Math.random() - 0.5));
        int newZ = (int)((double)this.z + (double)(spread * 2.0f) * (Math.random() - 0.5));
        BlockPos pos = world.func_175672_r(new BlockPos(newX, 0, newZ));
        while (world.func_180495_p(pos = pos.func_177984_a()).func_185904_a() instanceof MaterialLiquid) {
        }
        return new Location((World)world, pos);
    }

    public static VirtualLocationBuilder builder() {
        return new VirtualLocationBuilder();
    }

    public VirtualLocationBuilder toBuilder() {
        return new VirtualLocationBuilder().dim(this.dim).x(this.x).z(this.z).depth(this.depth);
    }

    public String toString() {
        return "VirtualLocation(dim=" + this.getDim() + ", x=" + this.getX() + ", z=" + this.getZ() + ", depth=" + this.getDepth() + ")";
    }

    public VirtualLocation(int dim, int x, int z, int depth) {
        this.dim = dim;
        this.x = x;
        this.z = z;
        this.depth = depth;
    }

    public VirtualLocation() {
    }

    public int getDim() {
        return this.dim;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getDepth() {
        return this.depth;
    }

    public static class VirtualLocationBuilder {
        private int dim;
        private int x;
        private int z;
        private int depth;

        VirtualLocationBuilder() {
        }

        public VirtualLocationBuilder dim(int dim) {
            this.dim = dim;
            return this;
        }

        public VirtualLocationBuilder x(int x) {
            this.x = x;
            return this;
        }

        public VirtualLocationBuilder z(int z) {
            this.z = z;
            return this;
        }

        public VirtualLocationBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public VirtualLocation build() {
            return new VirtualLocation(this.dim, this.x, this.z, this.depth);
        }

        public String toString() {
            return "VirtualLocation.VirtualLocationBuilder(dim=" + this.dim + ", x=" + this.x + ", z=" + this.z + ", depth=" + this.depth + ")";
        }
    }
}

