/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.delaunay.sweep;

import java.util.ArrayDeque;
import java.util.Collections;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationAlgorithm;
import org.poly2tri.triangulation.TriangulationConstraint;
import org.poly2tri.triangulation.TriangulationContext;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;
import org.poly2tri.triangulation.delaunay.sweep.AdvancingFront;
import org.poly2tri.triangulation.delaunay.sweep.AdvancingFrontNode;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepConstraint;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepDebugContext;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepPointComparator;
import org.poly2tri.triangulation.point.TPoint;

public class DTSweepContext
extends TriangulationContext<DTSweepDebugContext> {
    private final float ALPHA = 0.3f;
    protected AdvancingFront aFront;
    private TriangulationPoint _head;
    private TriangulationPoint _tail;
    protected Basin basin = new Basin();
    protected EdgeEvent edgeEvent = new EdgeEvent();
    private DTSweepPointComparator _comparator = new DTSweepPointComparator();

    public DTSweepContext() {
        this.clear();
    }

    @Override
    public void isDebugEnabled(boolean b) {
        if (b && this._debug == null) {
            this._debug = new DTSweepDebugContext(this);
        }
        this._debugEnabled = b;
    }

    public void removeFromList(DelaunayTriangle triangle) {
        this._triList.remove(triangle);
    }

    protected void meshClean(DelaunayTriangle triangle) {
        if (triangle != null) {
            ArrayDeque<DelaunayTriangle> deque = new ArrayDeque<DelaunayTriangle>();
            deque.addFirst(triangle);
            triangle.isInterior(true);
            while (!deque.isEmpty()) {
                DelaunayTriangle t1 = (DelaunayTriangle)deque.removeFirst();
                this._triUnit.addTriangle(t1);
                for (int i = 0; i < 3; ++i) {
                    DelaunayTriangle t2;
                    if (t1.cEdge[i] || (t2 = t1.neighbors[i]) == null || t2.isInterior()) continue;
                    t2.isInterior(true);
                    deque.addLast(t2);
                }
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this._triList.clear();
    }

    public AdvancingFront getAdvancingFront() {
        return this.aFront;
    }

    public void setHead(TriangulationPoint p1) {
        this._head = p1;
    }

    public TriangulationPoint getHead() {
        return this._head;
    }

    public void setTail(TriangulationPoint p1) {
        this._tail = p1;
    }

    public TriangulationPoint getTail() {
        return this._tail;
    }

    public void addNode(AdvancingFrontNode node) {
        this.aFront.addNode(node);
    }

    public void removeNode(AdvancingFrontNode node) {
        this.aFront.removeNode(node);
    }

    public AdvancingFrontNode locateNode(TriangulationPoint point) {
        return this.aFront.locateNode(point);
    }

    public void createAdvancingFront() {
        DelaunayTriangle iTriangle = new DelaunayTriangle((TriangulationPoint)this._points.get(0), this.getTail(), this.getHead());
        this.addToList(iTriangle);
        AdvancingFrontNode head = new AdvancingFrontNode(iTriangle.points[1]);
        head.triangle = iTriangle;
        AdvancingFrontNode middle = new AdvancingFrontNode(iTriangle.points[0]);
        middle.triangle = iTriangle;
        AdvancingFrontNode tail = new AdvancingFrontNode(iTriangle.points[2]);
        this.aFront = new AdvancingFront(head, tail);
        this.aFront.addNode(middle);
        this.aFront.head.next = middle;
        middle.next = this.aFront.tail;
        middle.prev = this.aFront.head;
        this.aFront.tail.prev = middle;
    }

    public void mapTriangleToNodes(DelaunayTriangle t) {
        for (int i = 0; i < 3; ++i) {
            AdvancingFrontNode n;
            if (t.neighbors[i] != null || (n = this.aFront.locatePoint(t.pointCW(t.points[i]))) == null) continue;
            n.triangle = t;
        }
    }

    @Override
    public void prepareTriangulation(Triangulatable t) {
        double ymin;
        double xmin;
        super.prepareTriangulation(t);
        double xmax = xmin = ((TriangulationPoint)this._points.get(0)).getX();
        double ymax = ymin = ((TriangulationPoint)this._points.get(0)).getY();
        for (TriangulationPoint p : this._points) {
            if (p.getX() > xmax) {
                xmax = p.getX();
            }
            if (p.getX() < xmin) {
                xmin = p.getX();
            }
            if (p.getY() > ymax) {
                ymax = p.getY();
            }
            if (!(p.getY() < ymin)) continue;
            ymin = p.getY();
        }
        double deltaX = (double)0.3f * (xmax - xmin);
        double deltaY = (double)0.3f * (ymax - ymin);
        TPoint p1 = new TPoint(xmax + deltaX, ymin - deltaY);
        TPoint p2 = new TPoint(xmin - deltaX, ymin - deltaY);
        this.setHead(p1);
        this.setTail(p2);
        Collections.sort(this._points, this._comparator);
    }

    public void finalizeTriangulation() {
        this._triUnit.addTriangles(this._triList);
        this._triList.clear();
    }

    @Override
    public TriangulationConstraint newConstraint(TriangulationPoint a, TriangulationPoint b) {
        return new DTSweepConstraint(a, b);
    }

    @Override
    public TriangulationAlgorithm algorithm() {
        return TriangulationAlgorithm.DTSweep;
    }

    class EdgeEvent {
        DTSweepConstraint constrainedEdge;
        public boolean right;

        EdgeEvent() {
        }
    }

    class Basin {
        AdvancingFrontNode leftNode;
        AdvancingFrontNode bottomNode;
        AdvancingFrontNode rightNode;
        public double width;
        public boolean leftHighest;

        Basin() {
        }
    }
}

