/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eerieentities;

import com.jarhax.eerieentities.CreativeTabEerieEntites;
import com.jarhax.eerieentities.block.BlockCarvedPumpkin;
import com.jarhax.eerieentities.client.ClientEvents;
import com.jarhax.eerieentities.client.ShaderHandler;
import com.jarhax.eerieentities.client.gui.FontRendererRunelic;
import com.jarhax.eerieentities.client.renderer.entity.RenderCursedArmor;
import com.jarhax.eerieentities.client.renderer.entity.RenderPumpkinSlime;
import com.jarhax.eerieentities.client.renderer.entity.RenderWisp;
import com.jarhax.eerieentities.client.renderer.entity.knight.RenderNetherKnight;
import com.jarhax.eerieentities.config.Config;
import com.jarhax.eerieentities.entities.EntityCursedArmor;
import com.jarhax.eerieentities.entities.EntityNetherKnight;
import com.jarhax.eerieentities.entities.EntityPumpkinSlime;
import com.jarhax.eerieentities.entities.EntityWisp;
import com.jarhax.eerieentities.items.ItemBlockArmor;
import com.jarhax.eerieentities.items.ItemNetherShield;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.network.NetworkHandler;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="eerieentities", name="Eerie Entities", version="1.0.7", dependencies="required-after:bookshelf@[2.3.566,);", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", guiFactory="com.jarhax.eerieentities.client.gui.GuiFactoryEerieEntities", acceptedMinecraftVersions="[1.12.2]")
public class EerieEntities {
    public static final String MODID = "eerieentities";
    public static final String NAME = "Eerie Entities";
    public static final LoggingHelper LOG = new LoggingHelper("Eerie Entities");
    public static final RegistryHelper REGISTRY = new RegistryHelper("eerieentities").setTab((CreativeTabs)new CreativeTabEerieEntites()).enableAutoRegistration();
    public static final NetworkHandler NETWORK = new NetworkHandler("eerieentities");
    public static final ResourceLocation LOOT_WISP = REGISTRY.registerLootTable("entities/wisp");
    public static final ResourceLocation LOOT_PUMPKIN_SLIME = REGISTRY.registerLootTable("entities/pumpkin_slime");
    public static final ResourceLocation LOOT_NETHER_KNIGHT = REGISTRY.registerLootTable("entities/nether_knight");
    public static final ResourceLocation LOOT_CURSED_ARMOR = REGISTRY.registerLootTable("entities/cursed_armor");
    public static Item netherShield;
    @SideOnly(value=Side.CLIENT)
    public static FontRenderer fontRunelic;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Config.syncConfigData();
        REGISTRY.registerMob(EntityWisp.class, "wisp", 0, 65535, 0x33CCFF);
        REGISTRY.registerMob(EntityPumpkinSlime.class, "pumpkin_slime", 1, 11957015, 8407049);
        REGISTRY.registerMob(EntityNetherKnight.class, "nether_knight", 2, 16775294, 16167425);
        REGISTRY.registerMob(EntityCursedArmor.class, "cursed_armor", 3, 0xFFFFFF, 0);
        netherShield = REGISTRY.registerItem((Item)new ItemNetherShield(), "nether_shield");
        for (BlockCarvedPumpkin.PumpkinType type : BlockCarvedPumpkin.PumpkinType.values()) {
            if (type == BlockCarvedPumpkin.PumpkinType.NORMAL) continue;
            String name = type.name().toLowerCase();
            BlockCarvedPumpkin normal = new BlockCarvedPumpkin(type);
            ItemBlockArmor itemNormal = new ItemBlockArmor(EntityEquipmentSlot.HEAD, normal, type);
            REGISTRY.registerBlock((Block)normal, (ItemBlock)itemNormal, "pumpkin_" + name);
            normal.func_149663_c("pumpkin");
            BlockCarvedPumpkin lit = new BlockCarvedPumpkin(type);
            ItemBlock itemLit = new ItemBlock((Block)lit);
            REGISTRY.registerBlock((Block)lit, itemLit, "pumpkin_lit_" + name);
            lit.func_149663_c("litpumpkin");
            lit.func_149715_a(1.0f);
            type.setItems((Block)normal, (Block)lit);
            REGISTRY.addShapelessRecipe("light_pumpkin_" + name, new ItemStack((Item)itemLit), new Object[]{new ItemStack((Item)itemNormal), "torch"});
            REGISTRY.addShapelessRecipe("pumpkin_seeds_" + name, new ItemStack(Items.field_151080_bb, 4), new Object[]{new ItemStack((Item)itemNormal)});
            REGISTRY.addShapelessRecipe("pumpkin_pie_" + name, new ItemStack(Items.field_151158_bO), new Object[]{"egg", Items.field_151102_aT, new ItemStack((Item)itemNormal)});
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit(FMLPreInitializationEvent event) {
        ShaderHandler.registerShaders();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        RenderingRegistry.registerEntityRenderingHandler(EntityWisp.class, RenderWisp::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPumpkinSlime.class, RenderPumpkinSlime::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNetherKnight.class, RenderNetherKnight::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCursedArmor.class, RenderCursedArmor::new);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onClientInit(FMLInitializationEvent event) {
        fontRunelic = new FontRendererRunelic();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        Config.updateSpawnEntries();
    }
}

