/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eerieentities.entities;

import com.jarhax.eerieentities.EerieEntities;
import com.jarhax.eerieentities.config.Config;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.data.AttributeOperation;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityNetherKnight
extends EntityMob {
    private static final DataParameter<Integer> RUNE_WORD = EntityDataManager.func_187226_a(EntityNetherKnight.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final char[][] WORDS = new char[][]{{'D', 'A', 'R', 'K'}, {'F', 'I', 'R', 'E'}, {'G', 'E', 'G', 'Y'}, {'S', 'A', 'L', 'T'}, {'C', 'U', 'N', 'T'}};
    private static final AttributeModifier BUFF_ARMOR = new AttributeModifier(UUID.fromString("cb1a4e88-69d3-4ba4-a6de-ea98bc63114f"), "knight_buff_armor", Config.netherKnight.getBonusArmor(), AttributeOperation.ADDITIVE.ordinal());
    private static final AttributeModifier BUFF_HEALTH = new AttributeModifier(UUID.fromString("df154adf-523a-4523-bf02-08115e8a666f"), "knight_buff_health", Config.netherKnight.getBonusHealth(), AttributeOperation.ADDITIVE.ordinal());

    public EntityNetherKnight(World world) {
        super(world);
        this.field_70178_ae = true;
    }

    public int getRuneWord() {
        return (Integer)this.field_70180_af.func_187225_a(RUNE_WORD);
    }

    public void setRuneWord(int value) {
        this.field_70180_af.func_187227_b(RUNE_WORD, (Object)value);
    }

    public char getRune(int index) {
        return index >= 0 && index < 4 ? WORDS[this.getRuneWord()][index] : (char)'X';
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RUNE_WORD, (Object)0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setRuneWord(Constants.RANDOM.nextInt(WORDS.length));
        return livingdata;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("RuneWord", this.getRuneWord());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRuneWord(compound.func_74762_e("RuneWord"));
    }

    public float func_70047_e() {
        return this.field_70131_O * 1.15f;
    }

    public int func_70641_bl() {
        return Config.netherKnight.getMaxInChunk();
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        Config.netherKnight.apply((EntityLivingBase)this);
        this.field_70728_aV = Config.netherKnight.getBaseEXP();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.func_70026_G()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 25));
        }
    }

    public ResourceLocation func_184647_J() {
        return EerieEntities.LOOT_NETHER_KNIGHT;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity sourceEnt = source.func_76364_f();
        if (!source.func_76363_c() && (source.func_82725_o() || source.func_76352_a() || source.func_94541_c())) {
            amount /= 2.0f;
        }
        if (sourceEnt != null && MathsUtils.tryPercentage((double)Config.netherKnight.getBurnChance())) {
            sourceEnt.func_70015_d(1);
        }
        if (super.func_70097_a(source, amount)) {
            EntityLivingBase target = this.func_70638_az();
            if (target == null && source.func_76346_g() instanceof EntityLivingBase) {
                target = (EntityLivingBase)source.func_76346_g();
            }
            if (target != null && MathsUtils.tryPercentage((double)Config.netherKnight.getReinforcementChance())) {
                for (int attempt = 0; attempt < 25; ++attempt) {
                    int[] range = Config.netherKnight.getSpawnRange();
                    int spawnOffsetX = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)range[0], (int)range[1]) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    int spawnOffsetZ = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)range[0], (int)range[1]) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    BlockPos spawnPos = this.func_180425_c().func_177982_a(spawnOffsetX, -1, spawnOffsetZ);
                    IBlockState state = this.field_70170_p.func_180495_p(spawnPos);
                    if (state == null || !state.isSideSolid((IBlockAccess)this.field_70170_p, spawnPos, EnumFacing.UP) || !this.field_70170_p.func_175623_d(spawnPos.func_177981_b(2))) continue;
                    try {
                        EntityLiving reinforcement = (EntityLiving)EntityList.func_188429_b((ResourceLocation)Config.netherKnight.getReinforcementIDs()[Constants.RANDOM.nextInt(Config.netherKnight.getReinforcementIDs().length)], (World)this.field_70170_p);
                        reinforcement.func_70634_a((double)((float)spawnPos.func_177958_n() + 0.5f), this.field_70163_u, (double)((float)spawnPos.func_177952_p() + 0.5f));
                        reinforcement.func_70624_b(target);
                        this.field_70170_p.func_72838_d((Entity)reinforcement);
                        reinforcement.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(BUFF_ARMOR);
                        reinforcement.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(BUFF_HEALTH);
                        reinforcement.func_70606_j(reinforcement.func_110138_aP());
                    }
                    catch (Exception e) {
                        EerieEntities.LOG.catching((Throwable)e);
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }
}

