/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eerieentities.entities;

import com.google.common.base.Optional;
import com.jarhax.eerieentities.EerieEntities;
import com.jarhax.eerieentities.block.BlockCarvedPumpkin;
import com.jarhax.eerieentities.config.Config;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPumpkinSlime
extends EntitySlime
implements IEntityOwnable {
    private static final DataParameter<Boolean> IS_BLOCK = EntityDataManager.func_187226_a(EntityPumpkinSlime.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityPumpkinSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityPumpkinSlime.class, (DataSerializer)DataSerializers.field_187203_m);
    private float rotation = 0.0f;
    private boolean sitting = false;
    private boolean allowTaming = true;

    public EntityPumpkinSlime(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.99f, 0.99f);
    }

    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setType(int value) {
        this.field_70180_af.func_187227_b(TYPE, (Object)value);
    }

    public void setBlock(boolean value) {
        this.field_70180_af.func_187227_b(IS_BLOCK, (Object)value);
    }

    public boolean isBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BLOCK);
    }

    public BlockCarvedPumpkin.PumpkinType getPumpkinType() {
        return BlockCarvedPumpkin.PumpkinType.values()[this.getType()];
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BLOCK, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        Config.pumpkinSlime.apply((EntityLivingBase)this);
        this.field_70728_aV = Config.pumpkinSlime.getBaseEXP();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setType(Constants.RANDOM.nextInt(6));
        return livingdata;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70613_aW()) {
            if (this.func_70638_az() == null && this.func_184753_b() == null || this.isSitting()) {
                this.transformToBlock();
            } else if (this.isBlock() && this.func_70638_az() != null) {
                this.transformToSlime();
            }
            if (this.field_70170_p.func_72935_r() && Config.pumpkinSlime.isDieInSunlight()) {
                if (MathsUtils.tryPercentage((double)Config.pumpkinSlime.getSolidifyChance())) {
                    this.field_70170_p.func_175656_a(this.func_180425_c(), this.getPumpkinType().getNormal().func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)this.func_174811_aO()));
                }
                this.func_70106_y();
                this.func_70656_aK();
            }
        }
    }

    protected void func_175451_e(EntityLivingBase entityIn) {
        int i = 2;
        if (this.func_70685_l((Entity)entityIn) && this.func_70068_e((Entity)entityIn) < 1.44 && entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_70805_n())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((EntityLivingBase)this, (Entity)entityIn);
        }
    }

    public int func_70805_n() {
        return (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (!this.isBlock()) {
            super.func_70091_d(type, x, y, z);
        }
    }

    private void transformToSlime() {
        this.setBlock(false);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    private void transformToBlock() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_184753_b() == null) {
            this.field_70128_L = true;
        }
        if (!this.isBlock()) {
            this.field_70165_t = Math.floor(this.field_70165_t) + 0.5;
            this.field_70161_v = Math.floor(this.field_70161_v) + 0.5;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_180425_c());
            while (this.field_70170_p.func_175623_d((BlockPos)pos)) {
                pos.func_189536_c(EnumFacing.DOWN);
            }
            this.func_70107_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + 0.5f);
            this.rotation = (float)Math.round(this.field_70177_z / 90.0f) * 90.0f;
            this.func_70624_b(null);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(4.5);
            this.setBlock(true);
        }
        this.func_70101_b(this.rotation, 0.0f);
        this.field_70126_B = this.rotation;
        this.field_70759_as = this.rotation;
        this.field_70761_aq = this.rotation;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.func_191989_p(0.0f);
        this.func_184646_p(0.0f);
        this.func_70657_f(0.0f);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("IsBlockForm", this.isBlock());
        compound.func_74768_a("Type", this.getType());
        compound.func_74776_a("LookRotation", this.rotation);
        compound.func_74757_a("AllowTaming", this.allowTaming);
        if (this.func_184753_b() != null) {
            compound.func_186854_a("Owner", this.func_184753_b());
            compound.func_74757_a("Sitting", this.isSitting());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBlock(compound.func_74767_n("IsBlockForm"));
        this.setType(compound.func_74762_e("Type"));
        this.rotation = compound.func_74760_g("LookRotation");
        this.allowTaming = compound.func_74767_n("AllowTaming");
        if (compound.func_74764_b("Owner")) {
            this.setOwnerId(compound.func_186857_a("Owner"));
            this.setSitting(compound.func_74767_n("Sitting"));
        }
    }

    public ResourceLocation func_184647_J() {
        return EerieEntities.LOOT_PUMPKIN_SLIME;
    }

    public void func_70799_a(int size, boolean resetHealth) {
    }

    public int func_70809_q() {
        return 0;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public void func_70108_f(Entity entity) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    protected Item func_146068_u() {
        return null;
    }

    public int func_70641_bl() {
        return Config.pumpkinSlime.getMaxInChunk();
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(0.99f, 0.99f);
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)ownerId));
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).orNull();
    }

    public Entity func_70902_q() {
        return this.func_184753_b() != null ? this.field_70170_p.func_152378_a(this.func_184753_b()) : null;
    }

    public boolean func_70800_m() {
        return !this.isBlock() && this.func_70902_q() == null;
    }

    public SoundEvent func_184709_cY() {
        return this.isBlock() ? null : super.func_184709_cY();
    }

    public boolean spawnCustomParticles() {
        int size = 2;
        for (int indx = 0; indx < 16; ++indx) {
            float randomDegree = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float randomOffset = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
            float offsetX = MathHelper.func_76126_a((float)randomDegree) * 2.0f * 0.5f * randomOffset;
            float offsetZ = MathHelper.func_76134_b((float)randomDegree) * 2.0f * 0.5f * randomOffset;
            double particleX = this.field_70165_t + (double)offsetX;
            double particleY = this.field_70161_v + (double)offsetZ;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, this.func_174813_aQ().field_72338_b, particleY, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150423_aK.func_176223_P())});
        }
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70613_aW()) {
            ItemStack heldItem;
            if (this.isOwner(player)) {
                boolean shouldSit = !this.isSitting();
                this.setSitting(shouldSit);
                if (!shouldSit) {
                    this.transformToSlime();
                }
                return true;
            }
            if (this.allowTaming && Config.pumpkinSlime.isAllowTaming() && (heldItem = player.func_184586_b(hand)).func_77973_b() == Items.field_151158_bO) {
                heldItem.func_190918_g(1);
                if (MathsUtils.tryPercentage((double)Config.pumpkinSlime.getTameChance())) {
                    this.setOwnerId(player.getPersistentID());
                    this.playTameEffect(true);
                } else {
                    this.playTameEffect(false);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public void setSitting(boolean sit) {
        this.sitting = sit;
    }

    public boolean isOwner(EntityPlayer player) {
        return player != null && this.func_184753_b() != null && this.func_184753_b().equals(player.getPersistentID());
    }

    private void playTameEffect(boolean succeeded) {
        EnumParticleTypes enumparticletypes = succeeded ? EnumParticleTypes.HEART : EnumParticleTypes.SMOKE_NORMAL;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }
}

