/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.integration;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import com.feed_the_beast.mods.money.FTBMoney;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoneyReward
extends Reward {
    public static RewardType TYPE;
    public long value = 1L;
    public int randomBonus = 0;

    public MoneyReward(Quest quest) {
        super(quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(NBTTagCompound nbt) {
        nbt.func_74772_a("ftb_money", this.value);
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.value = nbt.func_74763_f("ftb_money");
        this.randomBonus = nbt.func_74762_e("random_bonus");
    }

    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
        data.writeVarInt(this.randomBonus);
    }

    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
        this.randomBonus = data.readVarInt();
    }

    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbmoney.money", new Object[0]));
        config.addInt("random_bonus", () -> this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.random_bonus", new Object[0]));
    }

    public void claim(EntityPlayerMP player, boolean notify) {
        long added = this.value + (long)player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1);
        FTBMoney.setMoney((EntityPlayer)player, FTBMoney.getMoney((EntityPlayer)player) + added);
        if (notify) {
            new MessageDisplayRewardToast(this.id, FTBMoney.moneyComponent(added), Icon.getIcon((String)"ftbmoney:textures/beastcoinmini.png")).sendTo(player);
        }
    }

    public String getAltTitle() {
        if (this.randomBonus > 0) {
            return TextFormatting.GOLD + FTBMoney.moneyString(this.value) + " - " + FTBMoney.moneyString(this.value + (long)this.randomBonus);
        }
        return TextFormatting.GOLD + FTBMoney.moneyString(this.value);
    }

    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.randomBonus + "-" + Long.toUnsignedString(this.value + (long)this.randomBonus);
        }
        return Long.toUnsignedString(this.value);
    }
}

