/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.shop;

import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.mods.money.net.MessageSyncShop;
import com.feed_the_beast.mods.money.shop.ShopTab;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class Shop
implements INBTSerializable<NBTTagCompound> {
    public static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    public static Shop SERVER;
    public static Shop CLIENT;
    public final Supplier<QuestFile> file;
    public final List<ShopTab> tabs = new ArrayList<ShopTab>();
    public boolean shouldSave = false;

    public Shop(Supplier<QuestFile> f) {
        this.file = f;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList b = new NBTTagList();
        for (ShopTab tab : this.tabs) {
            b.func_74742_a((NBTBase)tab.serializeNBT());
        }
        nbt.func_74782_a("tabs", (NBTBase)b);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.tabs.clear();
        NBTTagList t = nbt.func_150295_c("tabs", 10);
        for (int i = 0; i < t.func_74745_c(); ++i) {
            NBTTagCompound n = t.func_150305_b(i);
            ShopTab tab = new ShopTab(this);
            tab.deserializeNBT(n);
            this.tabs.add(tab);
        }
    }

    public void markDirty() {
        this.shouldSave = true;
        if (this.file.get() != null && !this.file.get().isClient()) {
            new MessageSyncShop(this).sendToAll();
        }
    }

    @Nullable
    public ShopTab getTab(String name) {
        String s = PATTERN.matcher(name).replaceAll("").toLowerCase();
        for (ShopTab tab : this.tabs) {
            if (!PATTERN.matcher(tab.title).replaceAll("").toLowerCase().equals(s)) continue;
            return tab;
        }
        for (ShopTab tab : this.tabs) {
            if (!PATTERN.matcher(tab.title).replaceAll("").toLowerCase().contains(s)) continue;
            return tab;
        }
        return null;
    }
}

