/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.units.IWithMeta;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.state.IBlockState;

public class StateHashMap<K extends IWithMeta<?>, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 8943547197335795989L;

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value == null && key instanceof IWithMeta) {
            value = super.get(((IWithMeta)key).withMetaAll());
        }
        return value;
    }

    public static StateHashMap<BlockState, IBlockState> parseReplacementsFrom(String[] strArray) {
        StateHashMap<BlockState, IBlockState> replacements = new StateHashMap<BlockState, IBlockState>();
        for (String str : strArray) {
            boolean error;
            if ((str = str.trim()).isEmpty()) continue;
            String[] split = str.split("->");
            boolean bl = error = split.length < 2;
            if (!error) {
                UnitId source = UnitId.from(split[0].trim());
                UnitId dest = UnitId.from(split[1].trim());
                boolean bl2 = error = source.isEmpty() || dest.isEmpty();
                if (!error) {
                    IBlockState replacement = null;
                    try {
                        replacement = dest.getIBlockState();
                    }
                    catch (Exception e) {
                        error = true;
                    }
                    if (replacement != null) {
                        for (BlockState state : source.getAllBlockStates()) {
                            replacements.put(state, replacement);
                        }
                    }
                }
            }
            if (!error) continue;
            ForgeMain.instance.getLogger().error("Unable to parse replacement from " + CommonString.doubleQuoted(str));
        }
        return replacements;
    }
}

