/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.entities.tnt;

import ghostgaming.explosivesmod.GhostsExplosives;
import ghostgaming.explosivesmod.objects.blocks.BlockTNTGhostsExplosives;
import ghostgaming.explosivesmod.objects.entities.EntityTNTGhostsExplosivesStaged;
import ghostgaming.explosivesmod.objects.explosions.ExplosionGhostsExplosives;
import ghostgaming.explosivesmod.util.config.ConfigBlockLightningTNT;
import ghostgaming.explosivesmod.util.config.ConfigBlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityLightningTNT
extends EntityTNTGhostsExplosivesStaged {
    public static DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityLightningTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(EntityLightningTNT.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLightningTNT(World world) {
        super(world);
    }

    public EntityLightningTNT(World world, double x, double y, double z, EntityLivingBase igniter, BlockTNTGhostsExplosives defusedBlock) {
        super(world, x, y, z, igniter, defusedBlock);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)this.getConfig().FUSE);
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
    }

    @Override
    public DataParameter<Integer> getFuseDataParameter() {
        return FUSE;
    }

    @Override
    public DataParameter<Integer> getStageDataParameter() {
        return STAGE;
    }

    @Override
    public void func_70071_h_() {
        this.setMotion();
        --this.fuse;
        if ((double)this.fuse == Math.floor((double)fuseLength * 0.75) && this.stage == 0) {
            this.spawnLightning(1, this.field_70170_p, 6);
            ++this.stage;
        }
        if ((double)this.fuse == Math.floor((double)fuseLength * 0.45) && this.stage == 1) {
            this.spawnLightning(2, this.field_70170_p, 7);
            ++this.stage;
        }
        if ((double)this.fuse == Math.floor((double)fuseLength * 0.2) && this.stage == 2) {
            this.spawnLightning(4, this.field_70170_p, 9);
            ++this.stage;
        }
        if (this.fuse == -5) {
            if (this.stage == 0) {
                this.explode();
            }
            this.spawnLightning(((ConfigBlockLightningTNT)this.getConfig()).LIGHTNING_AMOUNT, this.field_70170_p, 15);
            this.func_70106_y();
        }
        if (this.fuse <= 0) {
            this.func_82142_c(true);
            if (!this.field_70170_p.field_72995_K && this.stage == 3) {
                this.explode();
                ++this.stage;
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void explode() {
        ConfigBlockLightningTNT config = (ConfigBlockLightningTNT)this.getConfig();
        ExplosionGhostsExplosives explosion = new ExplosionGhostsExplosives(this.field_70170_p, this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, config.EXPLOSION_STRENGTH, config.EXPLOSION_SMOOTHNESS, false, config.DAMAGES_TERRAIN, config.DROP_BLOCKS, config.HURT_ENTITIES, config.HURT_PLAYERS);
        explosion.doExplosionA();
        explosion.doExplosionB(true);
    }

    @Override
    public ConfigBlockTNT getConfig() {
        return GhostsExplosives.CONFIG_TNT_LIGHTNING;
    }

    private void spawnLightning(int amount, World world, int radius) {
        for (int i = 0; i < amount; ++i) {
            BlockPos lightningPos = this.getLightningPosition(radius);
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)lightningPos.func_177958_n(), (double)lightningPos.func_177956_o(), (double)lightningPos.func_177952_p(), false));
        }
    }

    private BlockPos getLightningPosition(int radius) {
        double lightningY;
        double lightningX = this.field_70165_t + Math.cos(this.field_70146_Z.nextDouble() * Math.PI) * (this.field_70146_Z.nextDouble() * (double)(radius - -radius) - (double)radius);
        double lightningZ = this.field_70161_v + Math.sin(this.field_70146_Z.nextDouble() * Math.PI) * (this.field_70146_Z.nextDouble() * (double)(radius - -radius) - (double)radius);
        for (lightningY = this.field_70163_u + (double)radius; this.field_70170_p.func_180495_p(new BlockPos(lightningX, lightningY - 1.0, lightningZ)).func_185904_a() == Material.field_151579_a && lightningY > this.field_70163_u - (double)radius; lightningY -= 1.0) {
        }
        return new BlockPos(lightningX, lightningY, lightningZ);
    }
}

