/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.objects.entities.tnt;

import ghostgaming.explosivesmod.GhostsExplosives;
import ghostgaming.explosivesmod.objects.blocks.BlockTNTGhostsExplosives;
import ghostgaming.explosivesmod.objects.entities.EntityTNTGhostsExplosivesStaged;
import ghostgaming.explosivesmod.objects.explosions.ExplosionGhostsExplosives;
import ghostgaming.explosivesmod.util.config.ConfigBlockTNT;
import ghostgaming.explosivesmod.util.config.ConfigBlockTunnelingTNT;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityTunnelingTNT
extends EntityTNTGhostsExplosivesStaged {
    public static DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityTunnelingTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(EntityTunnelingTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    public static DataParameter<EnumFacing> FACING = EntityDataManager.func_187226_a(EntityTunnelingTNT.class, (DataSerializer)DataSerializers.field_187202_l);
    public static DataParameter<Integer> DISTANCE = EntityDataManager.func_187226_a(EntityTunnelingTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    public EnumFacing facing = EnumFacing.NORTH;
    public int distance = 0;
    public BlockPos direction;

    public EntityTunnelingTNT(World world) {
        super(world);
    }

    public EntityTunnelingTNT(World world, double x, double y, double z, EntityLivingBase igniter, BlockTNTGhostsExplosives defusedBlock) {
        super(world, x, y, z, igniter, defusedBlock);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)this.getConfig().FUSE);
        this.field_70180_af.func_187214_a(STAGE, (Object)0);
        this.field_70180_af.func_187214_a(FACING, (Object)EnumFacing.NORTH);
        this.field_70180_af.func_187214_a(DISTANCE, (Object)0);
    }

    @Override
    public DataParameter<Integer> getFuseDataParameter() {
        return FUSE;
    }

    @Override
    public DataParameter<Integer> getStageDataParameter() {
        return STAGE;
    }

    public DataParameter<EnumFacing> getFacingDataParameter() {
        return FACING;
    }

    public DataParameter<Integer> getDistanceDataParameter() {
        return DISTANCE;
    }

    @Override
    public void func_70071_h_() {
        this.setMotion();
        --this.fuse;
        if (this.fuse <= 0) {
            if (this.stage == 1 && (this.distance >= ((ConfigBlockTunnelingTNT)this.getConfig()).MAX_DISTANCE || this.field_70123_F)) {
                this.func_70106_y();
            } else if (!this.field_70170_p.field_72995_K) {
                this.explode();
                if (this.getStage() == 0) {
                    this.direction = this.getDirectionFromFacing();
                    this.func_189654_d(true);
                    ++this.stage;
                }
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected void setMotion() {
        if (this.stage == 0) {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
            if (this.field_70122_E) {
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
                this.field_70181_x *= -0.5;
            }
        } else {
            if ((int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70166_s != (int)this.field_70161_v) {
                ++this.distance;
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (this.distance < ((ConfigBlockTunnelingTNT)this.getConfig()).MAX_DISTANCE) {
                this.field_70159_w -= (double)this.direction.func_177958_n() * (double)0.04f;
                this.field_70181_x = 0.0;
                this.field_70179_y -= (double)this.direction.func_177952_p() * (double)0.04f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    @Override
    public void explode() {
        ConfigBlockTunnelingTNT config = (ConfigBlockTunnelingTNT)this.getConfig();
        if (this.getStage() == 0) {
            this.direction = this.getDirectionFromFacing();
            this.func_189654_d(true);
            ++this.stage;
        }
        ExplosionGhostsExplosives explosion = new ExplosionGhostsExplosives(this.field_70170_p, this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, config.EXPLOSION_STRENGTH, config.EXPLOSION_SMOOTHNESS, false, config.DAMAGES_TERRAIN, config.DROP_BLOCKS, config.HURT_ENTITIES, config.HURT_PLAYERS);
        explosion.doExplosionA();
        explosion.doExplosionB(true);
    }

    public void setFacing(EnumFacing facing) {
        this.field_70180_af.func_187227_b(this.getFacingDataParameter(), (Object)facing);
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setDistance(int distance) {
        this.field_70180_af.func_187227_b(this.getDistanceDataParameter(), (Object)distance);
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
        compound.func_74777_a("Facing", (short)this.getFacing().func_176745_a());
        compound.func_74777_a("Distance", (short)this.getDistance());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
        this.setFacing(EnumFacing.func_82600_a((int)compound.func_74765_d("Facing")));
        this.setDistance(compound.func_74765_d("Distance"));
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (this.getFuseDataParameter().equals(key)) {
            this.fuse = this.getFuseDataManager();
        } else if (this.getFacingDataParameter().equals(key)) {
            this.facing = this.getFacingDataManager();
        } else if (this.getDistanceDataParameter().equals(key)) {
            this.distance = this.getDistanceDataManager();
        }
    }

    public EnumFacing getFacingDataManager() {
        return (EnumFacing)this.field_70180_af.func_187225_a(this.getFacingDataParameter());
    }

    public int getDistanceDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDistanceDataParameter());
    }

    @Override
    public ConfigBlockTNT getConfig() {
        return GhostsExplosives.CONFIG_TNT_TUNNELING;
    }

    private BlockPos getDirectionFromFacing() {
        BlockPos direction = new BlockPos(0, 0, 1);
        if (this.facing == EnumFacing.EAST) {
            direction = new BlockPos(-1, 0, 0);
        } else if (this.facing == EnumFacing.SOUTH) {
            direction = new BlockPos(0, 0, -1);
        } else if (this.facing == EnumFacing.WEST) {
            direction = new BlockPos(1, 0, 0);
        }
        return direction;
    }
}

