/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.util.handlers;

import ghostgaming.explosivesmod.GhostsExplosives;
import ghostgaming.explosivesmod.init.BlockInit;
import ghostgaming.explosivesmod.init.ItemInit;
import ghostgaming.explosivesmod.init.PotionInit;
import ghostgaming.explosivesmod.init.RecipeInit;
import ghostgaming.explosivesmod.init.SoundInit;
import ghostgaming.explosivesmod.network.PacketRequestUpdateLandmine;
import ghostgaming.explosivesmod.network.PacketUpdateLandmine;
import ghostgaming.explosivesmod.util.handlers.ConfigHandler;
import ghostgaming.explosivesmod.util.handlers.TileEntityHandler;
import ghostgaming.explosivesmod.util.handlers.WorldGeneratorHandler;
import ghostgaming.explosivesmod.util.interfaces.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ItemInit.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockInit.BLOCKS.toArray(new Block[0]));
        TileEntityHandler.registerTileEntities();
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])RecipeInit.RECIPES.toArray(new IRecipe[0]));
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])SoundInit.SOUNDS.toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public static void onPotionRegister(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])PotionInit.POTIONS.toArray(new Potion[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ItemInit.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : BlockInit.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistry() {
        GhostsExplosives.proxy.preInit();
        GhostsExplosives.network = NetworkRegistry.INSTANCE.newSimpleChannel("ghostsexplosives");
        GhostsExplosives.network.registerMessage((IMessageHandler)new PacketUpdateLandmine.Handler(), PacketUpdateLandmine.class, 0, Side.CLIENT);
        GhostsExplosives.network.registerMessage((IMessageHandler)new PacketRequestUpdateLandmine.Handler(), PacketRequestUpdateLandmine.class, 1, Side.SERVER);
        WorldGeneratorHandler.registerGenerators();
    }

    public static void initRegistry() {
        GhostsExplosives.proxy.init();
        ConfigManager.sync((String)"ghostsexplosives", (Config.Type)Config.Type.INSTANCE);
        ConfigHandler.loadConfig();
    }

    public static void postInitRegistry() {
        GhostsExplosives.proxy.postInit();
    }
}

