/*
 * Decompiled with CFR 0.152.
 */
package ghostgaming.explosivesmod.world.gen;

import com.google.common.base.Predicate;
import ghostgaming.explosivesmod.init.BlockInit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGeneratorOres
implements IWorldGenerator {
    private WorldGenerator ore_overworld_sulfur;
    private WorldGenerator ore_overworld_potassium;
    private WorldGenerator ore_overworld_uranium;

    public WorldGeneratorOres() {
        this.ore_overworld_sulfur = new WorldGenMinable(BlockInit.ORE_SULFUR.func_176223_P(), BlockInit.ORE_SULFUR.getConfig().VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.ore_overworld_potassium = new WorldGenMinable(BlockInit.ORE_POTASSIUM.func_176223_P(), BlockInit.ORE_POTASSIUM.getConfig().VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.ore_overworld_uranium = new WorldGenMinable(BlockInit.ORE_URANIUM.func_176223_P(), BlockInit.ORE_URANIUM.getConfig().VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                break;
            }
            case 0: {
                this.runGenerator(this.ore_overworld_sulfur, world, random, chunkX, chunkZ, BlockInit.ORE_SULFUR.getConfig().CHANCE, BlockInit.ORE_SULFUR.getConfig().MIN_HEIGHT, BlockInit.ORE_SULFUR.getConfig().MAX_HEIGHT);
                this.runGenerator(this.ore_overworld_potassium, world, random, chunkX, chunkZ, BlockInit.ORE_POTASSIUM.getConfig().CHANCE, BlockInit.ORE_POTASSIUM.getConfig().MIN_HEIGHT, BlockInit.ORE_POTASSIUM.getConfig().MAX_HEIGHT);
                this.runGenerator(this.ore_overworld_uranium, world, random, chunkX, chunkZ, BlockInit.ORE_URANIUM.getConfig().CHANCE, BlockInit.ORE_URANIUM.getConfig().MIN_HEIGHT, BlockInit.ORE_URANIUM.getConfig().MAX_HEIGHT);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > 255) {
            throw new IllegalArgumentException("Ore generated outside of world");
        }
        int heightDifference = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = minHeight + random.nextInt(heightDifference);
            int z = chunkZ * 16 + random.nextInt(16);
            generator.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }
}

