/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.biome;

import com.someguyssoftware.gottschcore.biome.BiomeDictionaryManager;
import com.someguyssoftware.gottschcore.biome.BiomeTypeHolder;
import com.someguyssoftware.gottschcore.biome.BiomeTypeMap;
import com.someguyssoftware.gottschcore.biome.IBiomeDictionary;
import com.someguyssoftware.gottschcore.biome.IBiomeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeHelper {
    public static List<Biome> loadBiomesList(String[] biomes) {
        ArrayList<Biome> list = new ArrayList<Biome>();
        for (String biomeName : biomes) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
            if (list.contains(biome)) continue;
            list.add(biome);
        }
        return list;
    }

    public static void loadBiomeList(String[] biomeTypeNames, List<BiomeTypeHolder> typeHolders) {
        BiomeTypeHolder holder = null;
        Object t = null;
        for (String s : biomeTypeNames) {
            holder = null;
            t = BiomeTypeMap.getByName(s.trim().toUpperCase());
            if (t != null) {
                holder = new BiomeTypeHolder(0, t);
            } else {
                Iterator<IBiomeDictionary> iterator = BiomeDictionaryManager.getInstance().getAll().iterator();
                if (iterator.hasNext()) {
                    IBiomeDictionary d = iterator.next();
                    t = d.getTypeByName(s.toUpperCase());
                    holder = new BiomeTypeHolder(1, t);
                }
            }
            if (holder == null) continue;
            typeHolders.add(holder);
        }
    }

    public static boolean isBiomeAllowed(Biome biome, List<BiomeTypeHolder> whiteList, List<BiomeTypeHolder> blackList) {
        if (whiteList != null && whiteList.size() > 0) {
            for (BiomeTypeHolder holder : whiteList) {
                if (holder.getDictionaryId() == 0) {
                    if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)((BiomeDictionary.Type)holder.getBiomeType()))) continue;
                    return true;
                }
                for (IBiomeDictionary d : BiomeDictionaryManager.getInstance().getAll()) {
                    if (!d.isBiomeOfType(biome, (IBiomeType)holder.getBiomeType())) continue;
                    return true;
                }
            }
            return false;
        }
        if (blackList != null && blackList.size() > 0) {
            for (BiomeTypeHolder holder : blackList) {
                if (holder.getDictionaryId() == 0) {
                    if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)((BiomeDictionary.Type)holder.getBiomeType()))) continue;
                    return false;
                }
                for (IBiomeDictionary d : BiomeDictionaryManager.getInstance().getAll()) {
                    if (!d.isBiomeOfType(biome, (IBiomeType)holder.getBiomeType())) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

