/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.config;

import com.someguyssoftware.gottschcore.config.IConfig;
import com.someguyssoftware.gottschcore.config.ILoggerConfig;
import com.someguyssoftware.gottschcore.mod.IMod;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;

public abstract class AbstractConfig
implements IConfig,
ILoggerConfig {
    private IMod mod;
    private Configuration forgeConfiguration;
    private String loggerLevel;
    private String loggerFolder;
    private String loggerSize;
    private String loggerFilename;
    private String modsFolder;
    private String configFolder;
    private boolean modEnabled;
    private boolean enableVersionChecker;
    private String latestVersion;
    private boolean latestVersionReminder;

    public AbstractConfig(IMod mod, File configDir, String modDir, String filename) {
        Configuration configuration;
        this.mod = mod;
        String configPath = configDir + "/" + modDir + "/";
        File configFile = new File(configPath + filename);
        this.forgeConfiguration = configuration = this.load(configFile);
    }

    @Override
    public Configuration load(File file) {
        Configuration config = IConfig.super.load(file);
        String modID = this.mod.getClass().getAnnotation(Mod.class).modid();
        config.setCategoryComment("01-logging", "Logging properties.");
        this.setLoggerLevel(config.getString("loggerLevel", "01-logging", "info", "The logging level. Set to 'off' to disable logging. [trace|debug|info|warn|error|off]"));
        this.setLoggerFolder(config.getString("loggerFolder", "01-logging", "logs/" + modID, "The directory where the logs should be stored. This is relative to the Minecraft install path."));
        this.setLoggerSize(config.getString("loggerSize", "01-logging", "1000K", "The size a log file can be before rolling over to a new file."));
        this.setLoggerFilename(config.getString("loggerFilename", "01-logging", modID, "The filename of the  log file."));
        config.setCategoryComment("03-mod", "General mod properties.");
        this.setModsFolder("mods");
        this.setConfigFolder("config/" + modID);
        this.setModEnabled(config.getBoolean("modEnabled", "03-mod", true, "Enables/Disables mod."));
        this.setEnableVersionChecker(config.getBoolean("enableVersionChecker", "03-mod", true, "Enables/Disables version checking."));
        this.setLatestVersion(config.getString("latestVersion", "03-mod", "", "The latest published version number."));
        this.setLatestVersionReminder(config.getBoolean("latestVersionReminder", "03-mod", true, "Remind the user of the latest version (as indicated in latestVersion proeprty) update."));
        return config;
    }

    @Override
    public void setProperty(Property property, String value) {
        property.set(value);
        this.getForgeConfiguration().save();
    }

    @Override
    public void setProperty(String category, String key, String value) {
        Property property = this.getForgeConfiguration().get(category, key, value);
        if (!property.getString().equals(value)) {
            property.set(value);
        }
        this.getForgeConfiguration().save();
    }

    @Override
    public void setProperty(String category, String key, boolean value) {
        Property property = this.getForgeConfiguration().get(category, key, value);
        if (!property.getBoolean() != value) {
            property.set(value);
        }
        this.getForgeConfiguration().save();
    }

    @Override
    public boolean isEnableVersionChecker() {
        return this.enableVersionChecker;
    }

    @Override
    public void setEnableVersionChecker(boolean enableVersionChecker) {
        this.enableVersionChecker = enableVersionChecker;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Override
    public boolean isLatestVersionReminder() {
        return this.latestVersionReminder;
    }

    @Override
    public void setLatestVersionReminder(boolean latestVersionReminder) {
        this.latestVersionReminder = latestVersionReminder;
    }

    @Override
    public Configuration getForgeConfiguration() {
        return this.forgeConfiguration;
    }

    @Override
    public void setForgeConfiguration(Configuration forgeConfiguration) {
        this.forgeConfiguration = forgeConfiguration;
    }

    @Override
    public String getLoggerLevel() {
        return this.loggerLevel;
    }

    public void setLoggerLevel(String loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    @Override
    public String getLoggerFolder() {
        return this.loggerFolder;
    }

    public void setLoggerFolder(String loggerFolder) {
        this.loggerFolder = loggerFolder;
    }

    @Override
    public String getLoggerSize() {
        return this.loggerSize;
    }

    public void setLoggerSize(String loggerSize) {
        this.loggerSize = loggerSize;
    }

    @Override
    public String getLoggerFilename() {
        return this.loggerFilename;
    }

    public void setLoggerFilename(String loggerFilename) {
        this.loggerFilename = loggerFilename;
    }

    @Override
    public boolean isModEnabled() {
        return this.modEnabled;
    }

    @Override
    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    @Override
    public String getModsFolder() {
        return this.modsFolder;
    }

    @Override
    public void setModsFolder(String modsFolder) {
        this.modsFolder = modsFolder;
    }

    @Override
    public String getConfigFolder() {
        return this.configFolder;
    }

    @Override
    public void setConfigFolder(String configFolder) {
        this.configFolder = configFolder;
    }
}

