/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.cube;

import com.someguyssoftware.gottschcore.positional.ICoords;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Cube {
    private final ICoords coords;
    private final IBlockState state;

    public Cube(World world, ICoords coords) {
        this.coords = coords;
        this.state = world.func_180495_p(coords.toPos());
    }

    public Cube(ICoords coords, IBlockState state) {
        this.coords = coords;
        this.state = state;
    }

    public IBlockState getState() {
        return this.state;
    }

    public Block toBlock() {
        if (this.state != null) {
            return this.state.func_177230_c();
        }
        return null;
    }

    public static Block toBlock(World world, ICoords coords) {
        IBlockState blockState = world.func_180495_p(coords.toPos());
        if (blockState != null) {
            return blockState.func_177230_c();
        }
        return null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean equalsBlock(Block block) {
        return this.state.func_177230_c() == block;
    }

    public boolean equalsMaterial(Material material) {
        return this.state.func_185904_a() == material;
    }

    public boolean isAir() {
        return this.state.func_185904_a() == Material.field_151579_a;
    }

    public boolean isReplaceable() {
        return this.state.func_185904_a().func_76222_j();
    }

    public boolean isSolid() {
        return this.getState().func_185904_a().func_76220_a();
    }

    public boolean isTopSolid() {
        return this.getState().func_185896_q();
    }

    public boolean isLiquid() {
        return this.getState().func_185904_a().func_76224_d();
    }

    public boolean isBurning(World world) {
        return this.toBlock().isBurning((IBlockAccess)world, this.coords.toPos());
    }

    public ICoords getCoords() {
        return this.coords;
    }

    public String toString() {
        return "Cube [coords=" + this.coords.toShortString() + ", state=" + this.state + "]";
    }
}

