/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot;

import com.google.common.io.Resources;
import com.google.gson.JsonParseException;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.loot.LootTableManager;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.gottschcore.version.VersionChecker;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import org.apache.commons.io.FilenameUtils;

@Deprecated
public class LootTableMaster {
    private IMod mod;
    private String lootTablesFolderName;
    private LootContext context;
    private LootTableManager lootTableManager;
    private Map<String, List<ResourceLocation>> lootTablesResourceLocationMap = new HashMap<String, List<ResourceLocation>>();
    private Map<String, List<LootTable>> lootTablesMap = new HashMap<String, List<LootTable>>();

    public LootTableMaster(IMod mod, String resourcePath, String folderName) {
        this.mod = mod;
        this.lootTablesFolderName = folderName;
        this.lootTableManager = new LootTableManager(Paths.get(this.getMod().getConfig().getConfigFolder(), new String[0]).toAbsolutePath().toFile());
    }

    public void buildAndExpose(String resourceRootPath, String modID, List<String> locations) {
        GottschCore.logger.debug("loot table folder locations -> {}", locations);
        for (String location : locations) {
            GottschCore.logger.debug("buildAndExpose location -> {}", (Object)location);
            this.createLootTableFolder(modID, location);
            this.exposeLootTable(resourceRootPath, modID, location);
        }
    }

    public void init(WorldServer world) {
        this.context = new LootContext.Builder(world, this.lootTableManager).build();
    }

    public void register(String modID, List<String> locations) {
        for (String location : locations) {
            List<ResourceLocation> locs = this.getLootTablesResourceLocations(modID, location);
            String key = this.getMod().getId() + ":" + this.getLootTablesFolderName() + "/" + modID + "/" + location;
            if (!this.lootTablesResourceLocationMap.containsKey(key)) {
                this.lootTablesResourceLocationMap.put(key, locs);
            }
            for (ResourceLocation loc : locs) {
                LootTable lootTable = this.lootTableManager.getLootTableFromLocation(loc);
                if (!this.lootTablesMap.containsKey(key)) {
                    this.lootTablesMap.put(key, new ArrayList());
                }
                GottschCore.logger.debug("mapping [key][loot table] -> [{}] [{}]", (Object)key, (Object)loc);
                this.lootTablesMap.get(key).add(lootTable);
            }
        }
    }

    protected void createLootTableFolder(String modID, String location) {
        if (modID == null || modID.isEmpty()) {
            modID = this.getMod().getId();
        }
        Path configPath = Paths.get(this.getMod().getConfig().getConfigFolder(), new String[0]);
        Path folder = Paths.get(configPath.toString(), this.getMod().getId(), this.getLootTablesFolderName(), modID, location != null && !location.equals("") ? location + "/" : "").toAbsolutePath();
        if (Files.notExists(folder, new LinkOption[0])) {
            GottschCore.logger.debug("loot tables folder \"{}\" will be created.", (Object)folder.toString());
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                GottschCore.logger.warn("Unable to create loot tables folder \"{}\"", (Object)folder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exposeLootTable(String resourceRootPath, String modID, String location) {
        if (modID == null || modID.isEmpty()) {
            modID = this.getMod().getId();
        }
        location = location != null && !location.equals("") ? location + "/" : "";
        Path folder = null;
        Stream<Path> walk = null;
        FileSystem fs = this.getResourceAsFileSystem(resourceRootPath, modID, location);
        if (fs == null) {
            return;
        }
        try {
            Path resourceBasePath = fs.getPath(resourceRootPath, modID, location);
            folder = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), this.getLootTablesFolderName(), modID, location).toAbsolutePath();
            boolean isFirst = true;
            walk = Files.walk(resourceBasePath, 1, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path resourceFilePath = (Path)it.next();
                GottschCore.logger.debug("mod loot_table -> {}", (Object)resourceFilePath.toString());
                if (isFirst) {
                    if (Files.notExists(folder, new LinkOption[0])) {
                        this.createLootTableFolder(modID, location);
                    }
                } else {
                    if (Files.isDirectory(resourceFilePath, new LinkOption[0])) {
                        GottschCore.logger.debug("resource is a folder -> {}", (Object)resourceFilePath.toString());
                        continue;
                    }
                    Path fileSystemFilePath = Paths.get(folder.toString(), resourceFilePath.getFileName().toString()).toAbsolutePath();
                    GottschCore.logger.debug("folderLootTablePath -> {}", (Object)fileSystemFilePath.toString());
                    if (Files.notExists(fileSystemFilePath, new LinkOption[0])) {
                        this.copyResourceToFileSystem(resourceFilePath, fileSystemFilePath);
                    } else {
                        boolean isCurrent = false;
                        try {
                            isCurrent = this.fileSystemHasCurrentVersion(resourceFilePath, fileSystemFilePath);
                        }
                        catch (Exception e) {
                            GottschCore.logger.warn(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        GottschCore.logger.error("is file system loot table current -> {}", (Object)isCurrent);
                        if (!isCurrent) {
                            Files.move(fileSystemFilePath, Paths.get(folder.toString(), resourceFilePath.getFileName().toString() + ".bak").toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
                            this.copyResourceToFileSystem(resourceFilePath, fileSystemFilePath);
                        }
                    }
                }
                isFirst = false;
            }
        }
        catch (Exception e) {
            GottschCore.logger.error("error:", (Throwable)e);
        }
        finally {
            if (walk != null) {
                walk.close();
            }
        }
        if (fs != null && fs.isOpen()) {
            try {
                fs.close();
            }
            catch (IOException e) {
                GottschCore.logger.debug("An error occurred attempting to close the FileSystem:", (Throwable)e);
            }
        }
    }

    private void copyResourceToFileSystem(Path resourceFilePath, Path fileSystemFilePath) {
        InputStream is = LootTableMaster.class.getResourceAsStream(resourceFilePath.toString());
        try (FileOutputStream fos = new FileOutputStream(fileSystemFilePath.toFile());){
            int r;
            byte[] buf = new byte[2048];
            while ((r = is.read(buf)) != -1) {
                fos.write(buf, 0, r);
            }
        }
        catch (IOException e) {
            GottschCore.logger.error("Error exposing resource to file system.", (Throwable)e);
        }
    }

    private boolean fileSystemHasCurrentVersion(Path resourceFilePath, Path fileSystemFilePath) throws Exception {
        String urlStr;
        boolean result = true;
        GottschCore.logger.debug("Verifying the most current version for the loot table -> {} ...", (Object)fileSystemFilePath.getFileName());
        ResourceLocation loc = new ResourceLocation(this.getMod().getId(), resourceFilePath.toString().replace(".json", ""));
        LootTable fsLootTable = this.getLootTableManager().getLootTableFromLocation(loc);
        URL url = LootTableManager.class.getResource(resourceFilePath.toString());
        if (url == null) {
            return false;
        }
        try {
            urlStr = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new Exception(String.format("Couldn't load loot table %s from %s", resourceFilePath, url), e);
        }
        LootTable resourceLootTable = null;
        try {
            resourceLootTable = LootTableManager.loadLootTable(LootTableManager.getGsonInstance(), loc, urlStr, false, null);
        }
        catch (JsonParseException e) {
            throw new Exception(String.format("Couldn't load loot table %s from %s", resourceFilePath, url), e);
        }
        GottschCore.logger.debug("\n\t...file system loot table -> {}\n\t...version -> {}\n\t...resource loot table -> {}\n\t...version -> {}", (Object)fileSystemFilePath.toString(), (Object)fsLootTable.getVersion(), (Object)loc.toString(), (Object)resourceLootTable.getVersion());
        if (resourceLootTable != null && fsLootTable != null) {
            BuildVersion resourceVersion = new BuildVersion(resourceLootTable.getVersion());
            BuildVersion fsVersion = new BuildVersion(fsLootTable.getVersion());
            result = VersionChecker.checkVersion(resourceVersion, fsVersion);
        }
        return result;
    }

    protected FileSystem getResourceAsFileSystem(String resourceRootPath, String modID, String location) {
        FileSystem fs = null;
        HashMap env = new HashMap();
        URI uri = null;
        resourceRootPath = "/" + resourceRootPath.replaceAll("^/|/$", "") + "/";
        URL url = GottschCore.class.getResource(resourceRootPath + modID + "/" + location);
        if (url == null) {
            GottschCore.logger.error("Unable to locate resource {}", (Object)(resourceRootPath + modID + "/" + location));
            return null;
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            GottschCore.logger.error("An error occurred during loot table processing:", (Throwable)e);
            return null;
        }
        String[] array = uri.toString().split("!");
        try {
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
        }
        catch (IOException e) {
            GottschCore.logger.error("An error occurred during loot table processing:", (Throwable)e);
            return null;
        }
        return fs;
    }

    public List<ResourceLocation> getLootTablesResourceLocations(String modIDIn, String locationIn) {
        String modID = modIDIn == null || modIDIn.isEmpty() ? this.getMod().getId() : modIDIn;
        String location = locationIn != null && !locationIn.equals("") ? locationIn + "/" : "";
        ArrayList<ResourceLocation> locs = new ArrayList<ResourceLocation>();
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), this.getLootTablesFolderName(), modID, location).toAbsolutePath();
        GottschCore.logger.debug("Path to custom loot table -> {}", (Object)path.toString());
        if (Files.notExists(path, new LinkOption[0])) {
            GottschCore.logger.debug("Unable to locate -> {}", (Object)path.toString());
            return locs;
        }
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                GottschCore.logger.debug("Custom loot table file -> {}", (Object)f.toAbsolutePath().toString());
                if (FilenameUtils.getExtension((String)f.getFileName().toString()).equals("json")) {
                    ResourceLocation loc = new ResourceLocation(this.getMod().getId() + ":" + this.getLootTablesFolderName() + "/" + modID + "/" + location + f.getFileName().toString().replace(".json", ""));
                    GottschCore.logger.debug("Resource location -> {}", (Object)loc);
                    locs.add(loc);
                }
            });
        }
        catch (IOException e) {
            GottschCore.logger.error("Error processing custom loot table:", (Throwable)e);
        }
        return locs;
    }

    public String getLootTablesFolderName() {
        return this.lootTablesFolderName;
    }

    public void setLootTablesFolderName(String lootTablesFolderName) {
        this.lootTablesFolderName = lootTablesFolderName;
    }

    protected IMod getMod() {
        return this.mod;
    }

    protected void setMod(IMod mod) {
        this.mod = mod;
    }

    public LootContext getContext() {
        return this.context;
    }

    protected void setContext(LootContext context) {
        this.context = context;
    }

    protected LootTableManager getLootTableManager() {
        return this.lootTableManager;
    }

    protected void setLootTableManager(LootTableManager lootTableManager) {
        this.lootTableManager = lootTableManager;
    }

    protected Map<String, List<ResourceLocation>> getLootTablesResourceLocationMap() {
        if (this.lootTablesResourceLocationMap == null) {
            this.lootTablesResourceLocationMap = new HashMap<String, List<ResourceLocation>>();
        }
        return this.lootTablesResourceLocationMap;
    }

    protected void setLootTablesResourceLocationMap(Map<String, List<ResourceLocation>> lootTablesResourceLocationMap) {
        this.lootTablesResourceLocationMap = lootTablesResourceLocationMap;
    }

    public Map<String, List<LootTable>> getLootTablesMap() {
        return this.lootTablesMap;
    }

    public void setLootTablesMap(Map<String, List<LootTable>> lootTablesMap) {
        this.lootTablesMap = lootTablesMap;
    }
}

