/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.mod;

import com.someguyssoftware.gottschcore.config.ILoggerConfig;
import com.someguyssoftware.gottschcore.eventhandler.LoginEventHandler;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.gottschcore.version.VersionChecker;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractMod
implements IMod {
    @Mod.EventHandler
    public void preInt(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new LoginEventHandler(this.getInstance()));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.getConfig().isEnableVersionChecker()) {
            BuildVersion buildVersion = null;
            if (this.getUpdateURL() != null && !this.getUpdateURL().equals("")) {
                buildVersion = VersionChecker.getVersionUsingForge(this);
            }
            if (buildVersion == null || buildVersion == BuildVersion.EMPTY_VERSION) {
                buildVersion = VersionChecker.getVersion(this.getVersionURL(), this.getMinecraftVersion());
            }
            this.setModLatestVersion(buildVersion);
        }
    }

    public String prependModID(String name) {
        return this.getId() + ":" + name;
    }

    @Override
    public abstract IMod getInstance();

    @Override
    public abstract String getVersion();

    public void addRollingFileAppenderToLogger(String loggerName, String appenderName, ILoggerConfig modConfig) {
        String loggerLevel = modConfig.getLoggerLevel();
        String loggerFolder = modConfig.getLoggerFolder();
        if (!loggerFolder.endsWith("/")) {
            loggerFolder = loggerFolder + "/";
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)modConfig.getLoggerSize());
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c | %F:%L | %m%n").withAlwaysWriteExceptions(true).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(loggerFolder + modConfig.getLoggerFilename() + ".log").withFilePattern(loggerFolder + modConfig.getLoggerFilename() + "-%d{yyyy-MM-dd-HH_mm_ss}.log").withAppend(true).withName(appenderName)).withBufferedIo(true)).withImmediateFlush(true)).withPolicy((TriggeringPolicy)policy).withLayout((Layout)layout)).withIgnoreExceptions(true)).withAdvertise(false).setConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef appenderReference = AppenderRef.createAppenderRef((String)appenderName, null, null);
        AppenderRef[] refs = new AppenderRef[]{appenderReference};
        Level level = Level.getLevel((String)loggerLevel.toUpperCase());
        LoggerConfig loggerConfig = LoggerConfig.createLogger((String)"false", (Level)level, (String)loggerName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger(loggerName, loggerConfig);
        loggerContext.updateLoggers();
    }

    public Appender createRollingFileAppender(String appenderName, ILoggerConfig modConfig) {
        String loggerFolder = modConfig.getLoggerFolder();
        if (!loggerFolder.endsWith("/")) {
            loggerFolder = loggerFolder + "/";
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)modConfig.getLoggerSize());
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c | %F:%L | %m%n").withAlwaysWriteExceptions(true).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(loggerFolder + modConfig.getLoggerFilename() + ".log").withFilePattern(loggerFolder + modConfig.getLoggerFilename() + "-%d{yyyy-MM-dd-HH_mm_ss}.log").withAppend(true).withName(appenderName)).withBufferedIo(true)).withImmediateFlush(true)).withPolicy((TriggeringPolicy)policy).withLayout((Layout)layout)).withIgnoreExceptions(true)).withAdvertise(false).setConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        return appender;
    }

    public Appender createRollingFileAppender(IMod mod, String appenderName, ILoggerConfig modConfig) {
        Path loggerFilePath = Paths.get(modConfig.getLoggerFolder(), mod.getId(), modConfig.getLoggerFilename());
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)modConfig.getLoggerSize());
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c | %F:%L | %m%n").withAlwaysWriteExceptions(true).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(loggerFilePath + ".log").withFilePattern(loggerFilePath + "-%d{yyyy-MM-dd-HH_mm_ss}.log").withAppend(true).withName(appenderName)).withBufferedIo(true)).withImmediateFlush(true)).withPolicy((TriggeringPolicy)policy).withLayout((Layout)layout)).withIgnoreExceptions(true)).withAdvertise(false).setConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        return appender;
    }

    public void addAppenderToLogger(Appender appender, String loggerName, ILoggerConfig modConfig) {
        String loggerLevel = modConfig.getLoggerLevel();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        Level level = Level.getLevel((String)loggerLevel.toUpperCase());
        AppenderRef appenderReference = AppenderRef.createAppenderRef((String)appender.getName(), null, null);
        AppenderRef[] refs = new AppenderRef[]{appenderReference};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((String)"false", (Level)level, (String)loggerName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender(appender, null, null);
        config.addLogger(loggerName, loggerConfig);
        loggerContext.updateLoggers();
    }
}

