/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.tileentity;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.tileentity.AbstractProximityTileEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;

public class ProximitySpawnerTileEntity
extends AbstractProximityTileEntity {
    private ResourceLocation mobName;
    private Quantity mobNum;
    private Double spawnRange = 1.0;

    public ProximitySpawnerTileEntity() {
    }

    public ProximitySpawnerTileEntity(double proximity) {
        super(proximity);
    }

    @Override
    public void func_145839_a(NBTTagCompound parentNBT) {
        super.func_145839_a(parentNBT);
        try {
            this.mobName = parentNBT.func_150297_b("mobName", 8) ? new ResourceLocation(parentNBT.func_74779_i("mobName")) : DungeonHooks.getRandomDungeonMob((Random)new Random());
            int min = 1;
            boolean max = true;
            if (parentNBT.func_74764_b("mobNumMin")) {
                min = parentNBT.func_74762_e("mobNumMin");
            }
            if (parentNBT.func_74764_b("mobNumMax")) {
                min = parentNBT.func_74762_e("mobNumMax");
            }
            this.mobNum = new Quantity(min, (double)max);
            if (parentNBT.func_74764_b("spawnRange")) {
                Double spawnRange = parentNBT.func_74769_h("spawnRange");
                this.setSpawnRange(spawnRange);
            }
        }
        catch (Exception e) {
            GottschCore.logger.error("Error reading ProximitySpanwer properties from NBT:", (Throwable)e);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("mobName", this.getMobName().toString());
        tag.func_74768_a("mobNumMin", this.getMobNum().getMinInt());
        tag.func_74768_a("mobNumMax", this.getMobNum().getMaxInt());
        tag.func_74780_a("spawnRange", this.getSpawnRange().doubleValue());
        return tag;
    }

    @Override
    public void execute(World world, Random random, Coords blockCoords, Coords playerCoords) {
        int mobCount = RandomHelper.randomInt(random, this.getMobNum().getMinInt(), this.getMobNum().getMaxInt());
        for (int i = 0; i < mobCount; ++i) {
            EntityLiving entityLiving;
            Entity entity = EntityList.func_188429_b((ResourceLocation)this.getMobName(), (World)world);
            if (entity == null) {
                GottschCore.logger.debug("unable to create entity -> {}", (Object)this.getMobName());
                this.selfDestruct();
                return;
            }
            double x = (double)blockCoords.getX() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * this.getSpawnRange() + 0.5;
            double y = blockCoords.getY();
            double z = (double)blockCoords.getZ() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * this.getSpawnRange() + 0.5;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            if (!(entity instanceof EntityLiving) || !(entityLiving = (EntityLiving)entity).func_70601_bi() || !entityLiving.func_70058_J()) continue;
            entityLiving.field_70759_as = entityLiving.field_70177_z;
            entityLiving.field_70761_aq = entityLiving.field_70177_z;
            entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityLiving)), (IEntityLivingData)null);
            world.func_72838_d(entity);
            entityLiving.func_70642_aH();
        }
        this.selfDestruct();
    }

    private void selfDestruct() {
        this.setDead(true);
        this.func_145831_w().func_175698_g(this.func_174877_v());
        this.func_145831_w().func_175713_t(this.func_174877_v());
    }

    public ResourceLocation getMobName() {
        return this.mobName;
    }

    public void setMobName(ResourceLocation mobName) {
        this.mobName = mobName;
    }

    public Quantity getMobNum() {
        return this.mobNum;
    }

    public void setMobNum(Quantity mobNum) {
        this.mobNum = mobNum;
    }

    public Double getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(Double spawnRange) {
        this.spawnRange = spawnRange;
    }
}

