/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command.system;

import icbm.classic.command.system.ICommandGroup;
import icbm.classic.command.system.ISubCommand;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class SubCommand
implements ISubCommand {
    private final String name;
    protected ICommandGroup parent;

    public SubCommand(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUsage(ICommandSender sender) {
        if (this.parent == null) {
            return "/" + this.getName();
        }
        return this.parent.getUsage(sender) + " " + this.getName();
    }

    @Override
    public void displayHelp(ICommandSender sender) {
        this.collectHelpForAll(string -> this.sendHelpMessage(sender, (String)string));
        if (sender.func_174793_f() != null) {
            this.collectHelpWorldOnly(string -> this.sendHelpMessage(sender, (String)string));
        }
        if (sender instanceof MinecraftServer) {
            this.collectHelpServerOnly(string -> this.sendHelpMessage(sender, (String)string));
        }
    }

    private void sendHelpMessage(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString((this.getUsage(sender) + " " + message).trim()));
    }

    protected void collectHelpForAll(Consumer<String> consumer) {
        consumer.accept("");
    }

    protected void collectHelpWorldOnly(Consumer<String> consumer) {
    }

    protected void collectHelpServerOnly(Consumer<String> consumer) {
    }

    @Override
    public List<String> getTabSuggestions(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    @Override
    public void setParent(ICommandGroup parent) {
        this.parent = parent;
    }
}

