/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IBlastIgnore;
import icbm.classic.api.explosion.IBlastMovable;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigBlast;
import icbm.classic.content.blast.Blast;
import icbm.classic.content.blast.threaded.BlastAntimatter;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.packet.PacketRedmatterSizeSync;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class BlastRedmatter
extends Blast
implements IBlastTickable,
IBlastMovable {
    public static final float NORMAL_RADIUS = 70.0f;
    public static final float ENTITY_DESTROY_RADIUS = 6.0f;
    public static int MAX_BLOCKS_EDITS_PER_TICK = 100;
    public static int DEFAULT_BLOCK_EDITS_PER_TICK = 20;
    public static int MAX_LIFESPAN = 36000;
    public static float CHANCE_FOR_FLYING_BLOCK = 0.8f;
    public static boolean DO_DESPAWN = true;
    public static boolean doAudio = true;
    public static boolean doFlyingBlocks = true;
    public int lifeSpan = MAX_LIFESPAN;
    public int blocksEditsPerTick = -1;
    public boolean coloredBeams = true;
    public float targetSize = 0.0f;
    private int lastRadius = 1;
    private int radiusSkipCount = 0;

    public float getScaleFactor() {
        return this.field_77280_f / 70.0f;
    }

    public int getBlocksPerTick() {
        if (this.blocksEditsPerTick == -1) {
            this.blocksEditsPerTick = (int)Math.min((float)MAX_BLOCKS_EDITS_PER_TICK, (float)DEFAULT_BLOCK_EDITS_PER_TICK * this.getScaleFactor());
        }
        return this.blocksEditsPerTick;
    }

    @Override
    protected void onBlastCompleted() {
        AxisAlignedBB bounds = new AxisAlignedBB(this.field_77284_b - (double)this.field_77280_f, this.field_77285_c - (double)this.field_77280_f, this.field_77282_d - (double)this.field_77280_f, this.field_77284_b + (double)this.field_77280_f, this.field_77285_c + (double)this.field_77280_f, this.field_77282_d + (double)this.field_77280_f);
        List list = this.world().func_72872_a(EntityExplosion.class, bounds);
        for (Object obj : list) {
            EntityExplosion explosion;
            if (!(obj instanceof EntityExplosion) || (explosion = (EntityExplosion)((Object)obj)).getBlast() != this) continue;
            explosion.func_70106_y();
        }
    }

    @Override
    public boolean onBlastTick(int ticksExisted) {
        if (this.world().field_72995_K) {
            if (this.targetSize < this.field_77280_f) {
                this.field_77280_f -= (this.field_77280_f - this.targetSize) / 10.0f;
            } else if (this.targetSize > this.field_77280_f) {
                this.field_77280_f += (this.targetSize - this.field_77280_f) / 10.0f;
            }
        }
        return super.onBlastTick(ticksExisted);
    }

    @Override
    public boolean doExplode(int callCount) {
        if (!this.world().field_72995_K) {
            this.field_77280_f = (float)((double)this.field_77280_f - 0.1);
            if (this.field_77280_f < 50.0f) {
                this.field_77280_f -= (50.0f - this.field_77280_f) / 100.0f;
            }
            if (this.callCount % 10 == 0) {
                ICBMClassic.packetHandler.sendToAllAround((IPacket)new PacketRedmatterSizeSync(this.field_77280_f, this.getController().func_145782_y()), new NetworkRegistry.TargetPoint(this.world().field_73011_w.getDimension(), (double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), 256.0));
            }
            if (DO_DESPAWN && callCount >= this.lifeSpan || this.field_77280_f <= 0.0f) {
                this.completeBlast();
            }
            this.doDestroyBlocks();
            this.doEntityMovement();
            if (doAudio) {
                if (this.world().field_73012_v.nextInt(8) == 0) {
                    ICBMSounds.COLLAPSE.play(this.field_77287_j, this.location.x() + (Math.random() - 0.5) * (double)this.getBlastRadius(), this.location.y() + (Math.random() - 0.5) * (double)this.getBlastRadius(), this.location.z() + (Math.random() - 0.5) * (double)this.getBlastRadius(), 6.0f - this.world().field_73012_v.nextFloat(), 1.0f - this.world().field_73012_v.nextFloat() * 0.4f, true);
                }
                ICBMSounds.REDMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 3.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
            }
        }
        return false;
    }

    protected void doDestroyBlocks() {
        int currentRadius;
        long time = System.currentTimeMillis();
        int blocksDestroyed = 0;
        ++this.radiusSkipCount;
        boolean quickMath = true;
        if (this.radiusSkipCount > 20) {
            this.radiusSkipCount = 0;
            quickMath = false;
        }
        int n = currentRadius = quickMath ? this.lastRadius : 1;
        while ((float)currentRadius < this.getBlastRadius()) {
            for (int xr = -currentRadius; xr < currentRadius; ++xr) {
                for (int yr = -currentRadius; yr < currentRadius; ++yr) {
                    for (int zr = -currentRadius; zr < currentRadius; ++zr) {
                        IBlockState blockState;
                        Block block;
                        BlockPos blockPos = new BlockPos(this.location.xi() + xr, this.location.yi() + yr, this.location.zi() + zr);
                        double dist = this.location.distance((Vec3i)blockPos);
                        if (dist < (double)currentRadius && dist > (double)(currentRadius - 2) && (block = (blockState = this.field_77287_j.func_180495_p(blockPos)).func_177230_c()) != null) {
                            boolean isFluid;
                            boolean bl = isFluid = block instanceof BlockLiquid || block instanceof IFluidBlock;
                            if (!block.isAir(blockState, (IBlockAccess)this.world(), blockPos) && (isFluid && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) < 7 || !isFluid && blockState.func_185887_b(this.field_77287_j, blockPos) >= 0.0f)) {
                                this.field_77287_j.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), isFluid ? 2 : 3);
                                if (!isFluid && doFlyingBlocks && this.world().field_73012_v.nextFloat() > CHANCE_FOR_FLYING_BLOCK) {
                                    EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), blockPos, blockState);
                                    entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                                    entity.pitchChange = 50.0f * this.world().field_73012_v.nextFloat();
                                    this.world().func_72838_d((Entity)entity);
                                    this.affectEntity(this.getBlastRadius() * 2.0f, entity, false);
                                }
                                ++blocksDestroyed;
                            }
                        }
                        if (blocksDestroyed > this.getBlocksPerTick() || !this.isAlive) {
                            return;
                        }
                        if (System.currentTimeMillis() - time <= 30L) continue;
                        this.field_77280_f -= 1.0f;
                        return;
                    }
                }
            }
            this.lastRadius = currentRadius++;
        }
        this.lastRadius = (int)this.getBlastRadius() - 1;
    }

    protected void doEntityMovement() {
        float entityRadius = this.getBlastRadius() * 1.5f;
        Cube cube = new Cube((IPos3D)((Object)((Location)this.location.add(0.5)).sub(entityRadius)), (IPos3D)((Object)((Location)this.location.add(0.5)).add(entityRadius)));
        AxisAlignedBB bounds = cube.getAABB();
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        boolean doExplosion = true;
        for (Entity entity : allEntities) {
            doExplosion = !this.affectEntity(entityRadius, entity, doExplosion);
        }
    }

    public boolean affectEntity(float radius, Entity entity, boolean doExplosion) {
        IBlast blast;
        if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).field_71075_bZ.field_75102_a)) {
            return false;
        }
        if (entity == this.controller) {
            return false;
        }
        if (entity instanceof IBlastIgnore && ((IBlastIgnore)entity).canIgnore(this)) {
            return false;
        }
        double xDifference = entity.field_70165_t - (double)this.location.xi() + 0.5;
        double yDifference = entity.field_70163_u - (double)this.location.yi() + 0.5;
        double zDifference = entity.field_70161_v - (double)this.location.zi() + 0.5;
        double dst = this.location.distance(entity);
        entity.func_70024_g(-xDifference / dst / dst * 5.0, -yDifference / dst / dst * 5.0, -zDifference / dst / dst * 5.0);
        if (entity instanceof EntityPlayer) {
            entity.field_70133_I = true;
        }
        if (entity instanceof EntityExplosion && (blast = ((EntityExplosion)entity).getBlast()) instanceof BlastRedmatter) {
            BlastRedmatter rmBlast = (BlastRedmatter)blast;
            int otherSize = (int)Math.pow(this.getBlastRadius(), 3.0);
            int thisSize = (int)Math.pow(blast.getBlastRadius(), 3.0);
            double totalSize = otherSize + thisSize;
            double thisSizePct = (double)thisSize / totalSize;
            Vec3d totalDelta = rmBlast.getPosition().func_178788_d(this.getPosition());
            Vec3d thisDelta = totalDelta.func_186678_a(thisSizePct);
            if (this.field_77283_e != null) {
                this.field_77283_e.func_70024_g(thisDelta.field_72450_a, thisDelta.field_72448_b, thisDelta.field_72449_c);
            }
        }
        boolean explosionCreated = false;
        Pos pos = new Pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (pos.distance(this.location) < (double)(6.0f * this.getScaleFactor())) {
            if (entity instanceof EntityExplosion) {
                IBlast blast2 = ((EntityExplosion)entity).getBlast();
                if (blast2 instanceof BlastAntimatter) {
                    if (doAudio) {
                        ICBMSounds.EXPLOSION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 7.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
                    }
                    if ((double)this.world().field_73012_v.nextFloat() > 0.85 && !this.world().field_72995_K) {
                        entity.func_70106_y();
                        return explosionCreated;
                    }
                } else if (blast2 instanceof BlastRedmatter && ((BlastRedmatter)blast2).isAlive && this.isAlive) {
                    double sizeA = this.getBlastRadius();
                    sizeA = sizeA * sizeA * sizeA;
                    double sizeB = ((EntityExplosion)entity).getBlast().getBlastRadius();
                    sizeB = sizeB * sizeB * sizeB;
                    float radiusNew = (float)Math.cbrt(sizeA + sizeB);
                    this.callCount = (this.callCount + ((BlastRedmatter)blast2).callCount) / 2;
                    this.field_77280_f = radiusNew;
                    this.controller.func_70016_h(0.0, 0.0, 0.0);
                    ((BlastRedmatter)blast2).isAlive = false;
                    ((BlastRedmatter)blast2).controller.func_70106_y();
                }
                entity.func_70106_y();
            } else if (entity instanceof EntityMissile) {
                ((EntityMissile)entity).doExplosion();
            } else if (entity instanceof EntityExplosive) {
                ((EntityExplosive)entity).explode();
            } else if (entity instanceof EntityLiving || entity instanceof EntityPlayer) {
                entity.func_70097_a((DamageSource)new DamageSourceRedmatter(this), 2000.0f);
            } else {
                entity.func_70106_y();
                if (entity instanceof EntityFlyingBlock && this.field_77280_f < 120.0f) {
                    this.field_77280_f = (float)((double)this.field_77280_f + 0.05);
                }
            }
        }
        return explosionCreated;
    }

    @Override
    public boolean isMovable() {
        return ConfigBlast.REDMATTER_MOVEMENT;
    }

    public static class DamageSourceRedmatter
    extends DamageSource {
        public final BlastRedmatter blastRedmatter;

        public DamageSourceRedmatter(BlastRedmatter blastRedmatter) {
            super("icbm.redmatter");
            this.blastRedmatter = blastRedmatter;
        }
    }
}

