/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.cruise;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.tile.IRadioWaveSender;
import icbm.classic.content.blocks.launcher.TileLauncherPrefab;
import icbm.classic.content.blocks.launcher.cruise.ContainerCruiseLauncher;
import icbm.classic.content.blocks.launcher.cruise.GuiCruiseLauncher;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.entity.missile.MissileFlightType;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.FakeRadioSender;
import icbm.classic.prefab.inventory.ExternalInventory;
import icbm.classic.prefab.inventory.IInventoryProvider;
import icbm.classic.prefab.tile.IGuiTile;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCruiseLauncher
extends TileLauncherPrefab
implements IPacketIDReceiver,
IGuiTile,
IInventoryProvider<ExternalInventory> {
    public static final int DESCRIPTION_PACKET_ID = 0;
    public static final int SET_FREQUENCY_PACKET_ID = 1;
    public static final int SET_TARGET_PACKET_ID = 2;
    public static final int LAUNCH_PACKET_ID = 3;
    private static final int REDSTONE_CHECK_RATE = 40;
    private static final double ROTATION_SPEED = 10.0;
    protected final EulerAngle aim = new EulerAngle(0.0, 0.0, 0.0);
    protected final EulerAngle currentAim = new EulerAngle(0.0, 0.0, 0.0);
    protected long lastRotationUpdate = System.nanoTime();
    protected double deltaTime;
    protected ItemStack cachedMissileStack = ItemStack.field_190927_a;
    private ExternalInventory inventory;

    @Override
    public ExternalInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ExternalInventory(this, 2);
        }
        return this.inventory;
    }

    @Override
    public String getStatus() {
        String status;
        String color = "\u00a74";
        if (!this.hasChargeToFire()) {
            status = LanguageUtility.getLocal("gui.launcherCruise.statusNoPower");
        } else if (this.getInventory().func_70301_a(0).func_190926_b()) {
            status = LanguageUtility.getLocal("gui.launcherCruise.statusEmpty");
        } else if (this.getInventory().func_70301_a(0).func_77973_b() != ItemReg.itemMissile) {
            status = LanguageUtility.getLocal("gui.launcherCruise.invalidMissile");
        } else {
            IExplosive explosive = ICBMClassicHelpers.getExplosive(this.getInventory().func_70301_a(0));
            if (explosive == null) {
                status = LanguageUtility.getLocal("gui.launcherCruise.invalidMissile");
            } else if (!this.hasMissile()) {
                status = LanguageUtility.getLocal("gui.launcherCruise.notCruiseMissile");
            } else if (!this.hasTarget()) {
                status = LanguageUtility.getLocal("gui.launcherCruise.statusInvalid");
            } else if (this.isTooClose(this.getTarget())) {
                status = LanguageUtility.getLocal("gui.launcherCruise.targetToClose");
            } else if (!this.canSpawnMissileWithNoCollision()) {
                status = LanguageUtility.getLocal("gui.launcherCruise.noRoom");
            } else {
                color = "\u00a72";
                status = LanguageUtility.getLocal("gui.launcherCruise.statusReady");
            }
        }
        return color + status;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.deltaTime = (double)(System.nanoTime() - this.lastRotationUpdate) / 1.0E8;
        this.lastRotationUpdate = System.nanoTime();
        this.currentAim.moveTowards(this.aim, 10.0, this.deltaTime).clampTo360();
        if (this.isServer() && this.ticks % 40 == 0 && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0) {
            this.launch();
        }
    }

    @Override
    public void setTarget(Pos target) {
        super.setTarget(target);
        this.updateAimAngle();
    }

    protected void updateAimAngle() {
        if (this.getTarget() != null && !this.getTarget().isZero()) {
            Pos aimPoint = this.getTarget();
            Pos center = (Pos)new Pos((IPos3D)this).add(0.5);
            this.aim.set(center.toEulerAngle(aimPoint).clampTo360());
            this.aim.setYaw(EulerAngle.clampPos360(this.aim.yaw()));
        } else {
            this.aim.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    public PacketTile getGUIPacket() {
        return (PacketTile)new PacketTile("gui", 0, this).addData(new Object[]{this.getEnergy(), this.getFrequency(), this.getTarget().xi(), this.getTarget().yi(), this.getTarget().zi()});
    }

    @Override
    public boolean read(ByteBuf data, int id, EntityPlayer player, IPacket type) {
        if (!super.read(data, id, player, type)) {
            switch (id) {
                case 1: {
                    this.setFrequency(data.readInt());
                    return true;
                }
                case 2: {
                    this.setTarget(new Pos(data.readInt(), data.readInt(), data.readInt()));
                    return true;
                }
                case 3: {
                    this.launch();
                    return true;
                }
                case 0: {
                    if (this.isClient()) {
                        this.setEnergy(data.readInt());
                        this.setFrequency(data.readInt());
                        this.setTarget(new Pos(data.readInt(), data.readInt(), data.readInt()));
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeBoolean(!this.getInventory().func_70301_a(0).func_190926_b());
        if (this.getInventory().func_70301_a(0).func_190926_b()) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getInventory().func_70301_a(0));
        }
        buf.writeInt(this.getTarget().xi());
        buf.writeInt(this.getTarget().yi());
        buf.writeInt(this.getTarget().zi());
        buf.writeDouble(this.currentAim.yaw());
        buf.writeDouble(this.currentAim.pitch());
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.cachedMissileStack = buf.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buf) : ItemStack.field_190927_a;
        this.setTarget(new Pos(buf.readInt(), buf.readInt(), buf.readInt()));
        this.currentAim.setYaw(buf.readDouble());
        this.currentAim.setPitch(buf.readDouble());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInventory().load(nbt.func_74775_l("inventory"));
        this.currentAim.readFromNBT(nbt.func_74775_l("currentAim"));
        this.initFromLoad();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)this.getInventory().save(new NBTTagCompound()));
        nbt.func_74782_a("currentAim", (NBTBase)this.currentAim.writeNBT(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    protected void initFromLoad() {
        this.cachedMissileStack = this.inventory.func_70301_a(0);
        this.updateAimAngle();
        this.currentAim.set(this.aim);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.initFromLoad();
    }

    public boolean canLaunch() {
        return this.hasTarget() && this.hasMissile() && this.hasChargeToFire() && !this.isTooClose(this.getTarget()) && this.canSpawnMissileWithNoCollision();
    }

    protected boolean hasMissile() {
        ItemStack stackInSlot = this.getInventory().func_70301_a(0);
        return stackInSlot.func_77973_b() == ItemReg.itemMissile && ICBMClassicAPI.EX_MISSILE_REGISTRY.isEnabled(stackInSlot.func_77952_i());
    }

    protected boolean hasTarget() {
        return this.getTarget() != null && !this.getTarget().isZero();
    }

    protected boolean hasChargeToFire() {
        return this.checkExtract();
    }

    protected boolean canSpawnMissileWithNoCollision() {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos pos = this.func_174877_v().func_177982_a(x, 1, z);
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block.isAir(state, (IBlockAccess)this.field_145850_b, pos)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean launch() {
        if (this.canLaunch()) {
            this.extractEnergy();
            EntityMissile entityMissile = new EntityMissile(this.field_145850_b, (double)this.xi() + 0.5, (double)this.yi() + 1.5, (double)this.zi() + 0.5, -((float)this.currentAim.yaw()) - 180.0f, -((float)this.currentAim.pitch()), 2.0f);
            entityMissile.missileType = MissileFlightType.CRUISE_LAUNCHER;
            entityMissile.explosiveID = this.getInventory().func_70301_a(0).func_77952_i();
            entityMissile.acceleration = 1.0f;
            entityMissile.capabilityMissile.launchNoTarget();
            this.field_145850_b.func_72838_d((Entity)entityMissile);
            this.getInventory().func_70298_a(0, 1);
            return true;
        }
        return false;
    }

    public boolean isTooClose(Pos target) {
        return ((Pos)new Pos(this.func_174877_v()).add(0.5)).distance(new Pos(target.x() + 0.5, target.z() + 0.5, target.z() + 0.5)) < 20.0;
    }

    @Override
    public void receiveRadioWave(float hz, IRadioWaveSender sender, String messageHeader, Object[] data) {
        int frequency = (int)Math.floor(hz);
        if (this.isServer() && frequency == this.getFrequency()) {
            if (messageHeader.equals("activateLauncherWithTarget")) {
                Pos pos = (Pos)data[0];
                if (!this.isTooClose(pos)) {
                    this.setTarget(pos);
                    ((FakeRadioSender)sender).player.func_145747_a((ITextComponent)new TextComponentString("Aiming missile at " + pos));
                }
            } else if (messageHeader.equals("activateLauncher")) {
                ((FakeRadioSender)sender).player.func_145747_a((ITextComponent)new TextComponentString("Firing missile at " + this.getTarget()));
                this.launch();
            }
        }
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (slot == 0) {
            this.updateClient = true;
        }
    }

    @Override
    public boolean targetWithYValue() {
        return true;
    }

    @Override
    public boolean canStore(ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemMissile && this.getInventory().func_70301_a(0) == null) {
            return ICBMClassicAPI.EX_MISSILE_REGISTRY.isEnabled(itemStack.func_77952_i());
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Cube(-2.0, 0.0, -2.0, 2.0, 3.0, 2.0).add(new Pos((IPos3D)this)).toAABB();
    }

    @Override
    public Object getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerCruiseLauncher(player, this);
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player) {
        return new GuiCruiseLauncher(player, this);
    }
}

