/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.missile;

import icbm.classic.api.caps.IMissile;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.transform.vector.Pos;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityMissile
implements IMissile {
    public final EntityMissile missile;

    public CapabilityMissile(EntityMissile missile) {
        this.missile = missile;
    }

    @Override
    public void dropMissileAsItem() {
        ItemStack stack = this.toStack();
        if (stack != null && !stack.func_190926_b() && this.world() != null) {
            this.world().func_72838_d((Entity)new EntityItem(this.world(), this.x(), this.y(), this.z(), stack));
        }
        this.missile.func_70106_y();
    }

    @Override
    public BlastState doExplosion() {
        return this.missile.doExplosion();
    }

    @Override
    public boolean hasExploded() {
        return this.missile.isExploding;
    }

    @Override
    public ItemStack toStack() {
        return new ItemStack(ItemReg.itemMissile, 1, this.missile.explosiveID);
    }

    @Override
    public int getTicksInAir() {
        return this.missile.ticksInAir;
    }

    @Override
    public Entity getMissileEntity() {
        return this.missile;
    }

    @Override
    public void launch(double x, double y, double z, double height) {
        this.missile.launch(new Pos(x, y, z), (int)height);
    }

    @Override
    public void launchNoTarget() {
        this.missile.launch(null, 0);
    }

    @Override
    public World world() {
        return this.missile != null ? this.missile.field_70170_p : null;
    }

    @Override
    public double z() {
        return this.missile != null ? this.missile.field_70161_v : 0.0;
    }

    @Override
    public double x() {
        return this.missile != null ? this.missile.field_70165_t : 0.0;
    }

    @Override
    public double y() {
        return this.missile != null ? this.missile.field_70163_u : 0.0;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMissile.class, (Capability.IStorage)new Capability.IStorage<IMissile>(){

            @Nullable
            public NBTBase writeNBT(Capability<IMissile> capability, IMissile instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IMissile> capability, IMissile instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new CapabilityMissile(null));
    }
}

